/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathBuilder;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.spi.internal.CompilationUnitOverrideSupport;
import org.eclipse.scout.sdk.core.model.spi.internal.JreInfo;
import org.eclipse.scout.sdk.core.util.SdkException;

public class FileSystemWithOverride
extends FileSystem {
    private final JreInfo m_jreInfo;
    private final CompilationUnitOverrideSupport m_overrideSupport;
    private final Set<ClasspathEntry> m_cpEntries;

    protected FileSystemWithOverride(ClasspathBuilder cp) {
        super(cp.fullClasspath(), null, false);
        this.m_jreInfo = cp.jreInfo();
        this.m_cpEntries = cp.entries();
        this.m_overrideSupport = new CompilationUnitOverrideSupport();
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        NameEnvironmentAnswer answer = this.searchInOverrideSupport(compoundName);
        if (answer != null) {
            return answer;
        }
        return super.findType(compoundName);
    }

    private NameEnvironmentAnswer searchInOverrideSupport(char[] typeName, char[][] packageName) {
        char[] fqnWithSlash = CharOperation.concatWith((char[][])packageName, (char[])typeName, (char)'/');
        ICompilationUnit overrideCu = this.overrideSupport().get(fqnWithSlash);
        if (overrideCu != null) {
            return new NameEnvironmentAnswer(overrideCu, null);
        }
        return null;
    }

    private NameEnvironmentAnswer searchInOverrideSupport(char[][] compoundName) {
        char[] fqnWithSlash = CharOperation.concatWith((char[][])compoundName, (char)'/');
        ICompilationUnit overrideCu = this.overrideSupport().get(fqnWithSlash);
        if (overrideCu != null) {
            return new NameEnvironmentAnswer(overrideCu, null);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        NameEnvironmentAnswer answer = this.searchInOverrideSupport(typeName, packageName);
        if (answer != null) {
            return answer;
        }
        return super.findType(typeName, packageName);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        char[] fqnWithSlash = CharOperation.concatWith((char[][])compoundName, (char[])packageName, (char)'/');
        return this.overrideSupport().containsPackage(fqnWithSlash) || super.isPackage(compoundName, packageName);
    }

    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        NameEnvironmentAnswer answer = this.searchInOverrideSupport(compoundName);
        if (answer != null) {
            return answer;
        }
        return this.superFindType(compoundName, moduleName);
    }

    private NameEnvironmentAnswer superFindType(char[][] compoundName, char[] moduleName) {
        try {
            MethodHandle superFindType = MethodHandles.lookup().findSpecial(FileSystem.class, "findType", MethodType.methodType(NameEnvironmentAnswer.class, char[][].class, char[].class), FileSystemWithOverride.class);
            return superFindType.invoke(this, compoundName, moduleName);
        }
        catch (Throwable e) {
            throw new SdkException(e);
        }
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        NameEnvironmentAnswer answer = this.searchInOverrideSupport(typeName, packageName);
        if (answer != null) {
            return answer;
        }
        return this.superFindType(typeName, packageName, moduleName);
    }

    private NameEnvironmentAnswer superFindType(char[] typeName, char[][] packageName, char[] moduleName) {
        try {
            MethodHandle superFindType = MethodHandles.lookup().findSpecial(FileSystem.class, "findType", MethodType.methodType(NameEnvironmentAnswer.class, char[].class, char[][].class, char[].class), FileSystemWithOverride.class);
            return superFindType.invoke(this, typeName, packageName, moduleName);
        }
        catch (Throwable e) {
            throw new SdkException(e);
        }
    }

    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        for (ICompilationUnit icu : this.overrideSupport().getCompilationUnits()) {
            if (!CharOperation.equals((char[][])icu.getPackageName(), (char[][])qualifiedPackageName)) continue;
            return true;
        }
        return this.superHasCompilationUnit(qualifiedPackageName, moduleName, checkCUs);
    }

    private boolean superHasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        try {
            MethodHandle superHasCompilationUnit = MethodHandles.lookup().findSpecial(FileSystem.class, "hasCompilationUnit", MethodType.methodType(Boolean.TYPE, char[][].class, char[].class, Boolean.TYPE), FileSystemWithOverride.class);
            return superHasCompilationUnit.invoke(this, qualifiedPackageName, moduleName, checkCUs);
        }
        catch (Throwable e) {
            throw new SdkException(e);
        }
    }

    public CompilationUnitOverrideSupport overrideSupport() {
        return this.m_overrideSupport;
    }

    public Stream<ClasspathEntry> classpath() {
        return this.m_cpEntries.stream();
    }

    public Path jreHome() {
        return this.m_jreInfo.jreHome();
    }

    public void cleanup() {
        super.cleanup();
        this.m_overrideSupport.clear();
    }
}

