/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.util.SdkException;

public class JreInfo {
    private final Path m_rtSrcZip;
    private final boolean m_supportsJrtModules;
    private final Path m_jreHome;
    private List<Path> m_bootClasspath;

    public JreInfo(Path jreHome) {
        this.m_jreHome = (Path)Validate.notNull((Object)jreHome);
        this.m_rtSrcZip = JreInfo.resolveRtSourceZip(jreHome);
        Path jrt = jreHome.resolve("lib/jrt-fs.jar");
        this.m_supportsJrtModules = Files.isReadable(jrt) && Files.isRegularFile(jrt, new LinkOption[0]);
    }

    public Path rtSrcZip() {
        return this.m_rtSrcZip;
    }

    public Path jreHome() {
        return this.m_jreHome;
    }

    public boolean supportsJrtModules() {
        return this.m_supportsJrtModules;
    }

    public List<Path> bootClasspath() {
        if (this.m_bootClasspath == null) {
            this.m_bootClasspath = this.supportsJrtModules() ? Collections.emptyList() : this.resolvePlatformLibrariesLegacy();
        }
        return this.m_bootClasspath;
    }

    private List<Path> resolvePlatformLibrariesLegacy() {
        Path jreHome = this.jreHome();
        String osName = System.getProperty("os.name");
        Stream<Path> libDirs = StringUtils.isNotEmpty((CharSequence)osName) && osName.toLowerCase().startsWith("mac") ? Stream.of(jreHome.resolve("../Classes").normalize()) : Stream.of(jreHome.resolve("lib"), jreHome.resolve("lib/ext"));
        List<Path> result = libDirs.flatMap(JreInfo::listFiles).filter(JreInfo::isArchive).collect(Collectors.toList());
        Path classesDir = jreHome.resolve("classes");
        if (Files.isReadable(classesDir) && Files.isDirectory(classesDir, new LinkOption[0])) {
            result.add(classesDir);
        }
        return result;
    }

    private static Stream<Path> listFiles(Path directory) {
        try {
            return Files.list(directory);
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }

    private static boolean isArchive(Path candidate) {
        String name = candidate.getFileName().toString().toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".zip");
    }

    private static Path resolveRtSourceZip(Path jreHome) {
        Path innerSrcZip = jreHome.resolve("lib/src.zip");
        if (Files.isReadable(innerSrcZip) && Files.isRegularFile(innerSrcZip, new LinkOption[0])) {
            return innerSrcZip;
        }
        Path parent = jreHome.getParent();
        if (parent == null) {
            return null;
        }
        return parent.resolve("src.zip");
    }

    public String toString() {
        return String.valueOf(JreInfo.class.getSimpleName()) + " for " + this.jreHome();
    }

    public int hashCode() {
        return this.m_jreHome.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JreInfo other = (JreInfo)obj;
        return this.m_jreHome.equals(other.m_jreHome);
    }
}

