/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal.metavalue;

import java.lang.reflect.Array;
import org.eclipse.scout.sdk.core.model.api.IArrayMetaValue;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.AbstractValue;

class ArrayMetaValue
extends AbstractValue
implements IArrayMetaValue {
    private final IMetaValue[] m_metaArray;

    ArrayMetaValue(IMetaValue[] metaArray) {
        this.m_metaArray = metaArray;
    }

    @Override
    public MetaValueType type() {
        return MetaValueType.Array;
    }

    @Override
    public IMetaValue[] metaValueArray() {
        return this.m_metaArray;
    }

    @Override
    Object getInternalObject(Class<?> expectedType) {
        return this.m_metaArray;
    }

    @Override
    public <T> T get(Class<T> expectedType) {
        Class elementType;
        Object array;
        int n = this.m_metaArray.length;
        if (expectedType == Object.class) {
            array = new Object[n];
            elementType = Object.class;
        } else if (expectedType.isArray()) {
            elementType = expectedType.getComponentType();
            array = Array.newInstance(elementType, n);
        } else {
            if (n == 1) {
                return this.m_metaArray[0].get(expectedType);
            }
            throw new ClassCastException("expected type must be an array type: " + expectedType);
        }
        int i = 0;
        while (i < n) {
            Array.set(array, i, this.m_metaArray[i].get(elementType));
            ++i;
        }
        return (T)array;
    }

    public String toString() {
        int n = this.m_metaArray.length;
        char blockSeparator = n > 0 && (this.m_metaArray[0].type() == MetaValueType.Array || this.m_metaArray[0].type() == MetaValueType.Annotation) ? (char)'\n' : ' ';
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        buf.append(blockSeparator);
        if (n > 0) {
            int i = 0;
            while (i < n) {
                IMetaValue element = this.m_metaArray[i];
                if (i > 0) {
                    buf.append(',');
                    buf.append(blockSeparator);
                }
                buf.append(element.toString());
                ++i;
            }
        }
        buf.append(blockSeparator);
        buf.append('}');
        return buf.toString();
    }
}

