/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal.metavalue;

import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.model.spi.internal.metavalue.AbstractValue;

class ConstantMetaValue
extends AbstractValue {
    private final Constant m_constant;
    private final MetaValueType m_type;

    ConstantMetaValue(Constant c, MetaValueType type) {
        this.m_constant = c;
        this.m_type = type;
    }

    @Override
    public MetaValueType type() {
        return this.m_type;
    }

    Object getInternalObject() {
        switch (this.type()) {
            case Bool: {
                return this.m_constant.booleanValue();
            }
            case Byte: {
                return this.m_constant.byteValue();
            }
            case Char: {
                return Character.valueOf(this.m_constant.charValue());
            }
            case Double: {
                return this.m_constant.doubleValue();
            }
            case Float: {
                return Float.valueOf(this.m_constant.floatValue());
            }
            case Int: {
                return this.m_constant.intValue();
            }
            case Long: {
                return this.m_constant.longValue();
            }
            case Short: {
                return this.m_constant.shortValue();
            }
            case String: {
                return this.m_constant.stringValue();
            }
        }
        return this.m_constant;
    }

    @Override
    Object getInternalObject(Class<?> expectedType) {
        if (expectedType == Object.class) {
            return this.getInternalObject();
        }
        if (expectedType == Boolean.TYPE || expectedType == Boolean.class) {
            return this.m_constant.booleanValue();
        }
        if (expectedType == Byte.TYPE || expectedType == Byte.class) {
            return this.m_constant.byteValue();
        }
        if (expectedType == Character.TYPE || expectedType == Character.class) {
            return Character.valueOf(this.m_constant.charValue());
        }
        if (expectedType == Double.TYPE || expectedType == Double.class) {
            return this.m_constant.doubleValue();
        }
        if (expectedType == Float.TYPE || expectedType == Float.class) {
            return Float.valueOf(this.m_constant.floatValue());
        }
        if (expectedType == Integer.TYPE || expectedType == Integer.class) {
            return this.m_constant.intValue();
        }
        if (expectedType == Long.TYPE || expectedType == Long.class) {
            return this.m_constant.longValue();
        }
        if (expectedType == Short.TYPE || expectedType == Short.class) {
            return this.m_constant.shortValue();
        }
        if (expectedType == String.class) {
            return this.m_constant.stringValue();
        }
        return this.m_constant;
    }

    public String toString() {
        Object internalObject = this.getInternalObject(Object.class);
        if (internalObject == null) {
            return "null";
        }
        return internalObject.toString();
    }
}

