/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.signature;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.signature.Signature;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static boolean isUnresolved(String signature) {
        if (signature == null) {
            return false;
        }
        int pos = 0;
        if (!signature.isEmpty() && signature.charAt(0) == '+') {
            pos = 1;
        }
        return signature.length() > pos && signature.charAt(pos) == 'Q';
    }

    public static String getTypeSignature(IType t) {
        if (t == null) {
            return null;
        }
        return t.signature();
    }

    public static String createMethodIdentifier(IMethod method) {
        return SignatureUtils.createMethodIdentifier(method, false);
    }

    public static String createMethodIdentifier(IMethod method, boolean useErasureOnly) {
        List<IMethodParameter> parameters = method.parameters().list();
        ArrayList<String> signatures = new ArrayList<String>(parameters.size());
        for (IMethodParameter mp : parameters) {
            String typeSignature = SignatureUtils.getTypeSignature(mp.dataType());
            if (typeSignature == null) continue;
            if (useErasureOnly) {
                typeSignature = Signature.getTypeErasure(typeSignature);
            }
            signatures.add(typeSignature);
        }
        return SignatureUtils.createMethodIdentifier(method.elementName(), signatures);
    }

    public static String createMethodIdentifier(String methodName, Iterable<String> resolvedParamSignatures) {
        Iterator<String> iterator;
        StringBuilder methodIdBuilder = new StringBuilder();
        methodIdBuilder.append(methodName);
        methodIdBuilder.append('(');
        if (resolvedParamSignatures != null && (iterator = resolvedParamSignatures.iterator()).hasNext()) {
            methodIdBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                methodIdBuilder.append(',');
                methodIdBuilder.append(iterator.next());
            }
        }
        methodIdBuilder.append(')');
        return methodIdBuilder.toString();
    }

    public static String toFullyQualifiedName(String signature) {
        if (signature == null) {
            return null;
        }
        String[] typeArguments = Signature.getTypeArguments(signature);
        String sig = Signature.getTypeErasure(signature);
        String nameUpToPrimaryType = Signature.getSignatureSimpleName(sig).replace('.', '$');
        String pck = Signature.getSignatureQualifier(sig);
        StringBuilder buf = new StringBuilder(signature.length());
        if (pck.length() > 0) {
            buf.append(pck);
            buf.append('.');
        }
        buf.append(nameUpToPrimaryType);
        if (typeArguments.length > 0) {
            buf.append('<');
            buf.append(SignatureUtils.toFullyQualifiedName(typeArguments[0]));
            int i = 1;
            while (i < typeArguments.length) {
                buf.append(',');
                buf.append(SignatureUtils.toFullyQualifiedName(typeArguments[i]));
                ++i;
            }
            buf.append('>');
        }
        return buf.toString();
    }

    public static String boxPrimitiveSignature(String signature) {
        if (Signature.getTypeSignatureKind(signature) != 2) {
            return signature;
        }
        if ("Z".equals(signature)) {
            return "Ljava.lang.Boolean;";
        }
        if ("B".equals(signature)) {
            return "Ljava.lang.Byte;";
        }
        if ("C".equals(signature)) {
            return "Ljava.lang.Character;";
        }
        if ("D".equals(signature)) {
            return "Ljava.lang.Double;";
        }
        if ("F".equals(signature)) {
            return "Ljava.lang.Float;";
        }
        if ("I".equals(signature)) {
            return "Ljava.lang.Integer;";
        }
        if ("J".equals(signature)) {
            return "Ljava.lang.Long;";
        }
        if ("S".equals(signature)) {
            return "Ljava.lang.Short;";
        }
        return signature;
    }

    public static String unboxToPrimitiveSignature(String signature) {
        if (Signature.getTypeSignatureKind(signature) == 2) {
            return signature;
        }
        if ("Ljava.lang.Boolean;".equals(signature)) {
            return "Z";
        }
        if ("Ljava.lang.Byte;".equals(signature)) {
            return "B";
        }
        if ("Ljava.lang.Character;".equals(signature)) {
            return "C";
        }
        if ("Ljava.lang.Double;".equals(signature)) {
            return "D";
        }
        if ("Ljava.lang.Float;".equals(signature)) {
            return "F";
        }
        if ("Ljava.lang.Integer;".equals(signature)) {
            return "I";
        }
        if ("Ljava.lang.Long;".equals(signature)) {
            return "J";
        }
        if ("Ljava.lang.Short;".equals(signature)) {
            return "S";
        }
        return signature;
    }
}

