/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractJavaElementSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.IAnnotatableSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public abstract class AbstractAnnotatableSourceBuilder
extends AbstractJavaElementSourceBuilder
implements IAnnotatableSourceBuilder {
    private final List<IAnnotationSourceBuilder> m_annotations = new ArrayList<IAnnotationSourceBuilder>();

    public AbstractAnnotatableSourceBuilder(IAnnotatable element) {
        super(element);
        for (IAnnotation a : element.annotations().list()) {
            this.addAnnotation(new AnnotationSourceBuilder(a));
        }
    }

    public AbstractAnnotatableSourceBuilder(String elementName) {
        super(elementName);
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        super.createSource(source, lineDelimiter, context, validator);
        this.createAnnotations(source, lineDelimiter, context, validator);
    }

    protected void createAnnotations(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        List<IAnnotationSourceBuilder> annotations = this.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        ArrayList<String> annotationSources = new ArrayList<String>(annotations.size());
        for (IAnnotationSourceBuilder sb : annotations) {
            if (sb == null) continue;
            StringBuilder annotBuilder = new StringBuilder();
            sb.createSource(annotBuilder, lineDelimiter, context, validator);
            annotationSources.add(annotBuilder.toString());
        }
        Collections.sort(annotationSources, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = Integer.compare(o1.length(), o2.length());
                if (result != 0) {
                    return result;
                }
                return o1.compareTo(o2);
            }
        });
        for (String annotSource : annotationSources) {
            source.append(annotSource);
            source.append(lineDelimiter);
        }
    }

    @Override
    public void addAnnotation(IAnnotationSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("annotation source builder can not be null.");
        }
        this.m_annotations.add(builder);
    }

    @Override
    public boolean removeAnnotation(String annotationFqn) {
        Iterator<IAnnotationSourceBuilder> it = this.m_annotations.iterator();
        while (it.hasNext()) {
            if (!annotationFqn.equals(it.next().getName())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public void removeAllAnnotations() {
        this.m_annotations.clear();
    }

    @Override
    public List<IAnnotationSourceBuilder> getAnnotations() {
        return Collections.unmodifiableList(this.m_annotations);
    }
}

