/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.sourcebuilder.IJavaElementSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public abstract class AbstractJavaElementSourceBuilder
implements IJavaElementSourceBuilder {
    private String m_elementName;
    private ISourceBuilder m_comment;

    public AbstractJavaElementSourceBuilder(IJavaElement element) {
        this(element.elementName());
    }

    public AbstractJavaElementSourceBuilder(String elementName) {
        this.m_elementName = elementName;
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        if (this.getElementName() == null) {
            throw new IllegalArgumentException("element name is null!");
        }
        this.createComment(source, lineDelimiter, context, validator);
    }

    protected void createComment(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        if (this.getComment() != null) {
            StringBuilder commentBuilder = new StringBuilder();
            this.getComment().createSource(commentBuilder, lineDelimiter, context, validator);
            if (StringUtils.isNotBlank((CharSequence)commentBuilder)) {
                source.append((CharSequence)commentBuilder);
                source.append(lineDelimiter);
            }
        }
    }

    @Override
    public void setElementName(String elementName) {
        this.m_elementName = elementName;
    }

    @Override
    public String getElementName() {
        return this.m_elementName;
    }

    @Override
    public void setComment(ISourceBuilder commentSourceBuilder) {
        this.m_comment = commentSourceBuilder;
    }

    @Override
    public ISourceBuilder getComment() {
        return this.m_comment;
    }
}

