/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IArrayMetaValue;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public final class ExpressionSourceBuilderFactory {
    private ExpressionSourceBuilderFactory() {
    }

    public static ISourceBuilder createClassLiteral(final String signature) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(validator.useSignature(signature));
                source.append(SuffixConstants.SUFFIX_class);
            }
        };
    }

    public static ISourceBuilder createEnumValue(final String enumSignature, final String enumField) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String typeName = validator.useSignature(enumSignature);
                source.append(typeName);
                source.append('.');
                source.append(enumField);
            }
        };
    }

    public static ISourceBuilder createQuotedStringArray(Collection<String> elements, boolean formatWithNewlines) {
        ArrayList<3> a = new ArrayList<3>(elements.size());
        for (final String s : elements) {
            a.add(new ISourceBuilder(){

                @Override
                public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                    source.append(CoreUtils.toStringLiteral(s));
                }
            });
        }
        return ExpressionSourceBuilderFactory.createArray(a, formatWithNewlines);
    }

    public static ISourceBuilder createArray(final Collection<? extends ISourceBuilder> elements, final boolean formatWithNewlines) {
        return new ISourceBuilder(){

            @Override
            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String blockSeparator = formatWithNewlines ? lineDelimiter : " ";
                source.append('{');
                source.append(blockSeparator);
                int n = elements.size();
                if (n > 0) {
                    int i = 0;
                    for (ISourceBuilder element : elements) {
                        if (i > 0) {
                            source.append(',');
                            source.append(blockSeparator);
                        }
                        element.createSource(source, lineDelimiter, context, validator);
                        ++i;
                    }
                    source.append(blockSeparator);
                }
                source.append('}');
            }
        };
    }

    public static ISourceBuilder createFromMetaValue(IMetaValue metaValue) {
        switch (metaValue.type()) {
            case Null: {
                return new RawSourceBuilder("null");
            }
            case Int: {
                return new RawSourceBuilder(metaValue.get(Integer.class).toString());
            }
            case Byte: {
                return new RawSourceBuilder(metaValue.get(Byte.class).toString());
            }
            case Short: {
                return new RawSourceBuilder(metaValue.get(Short.class).toString());
            }
            case Char: {
                char ch = metaValue.get(Character.class).charValue();
                return new RawSourceBuilder("'" + ch + "'");
            }
            case Float: {
                float f = metaValue.get(Float.class).floatValue();
                return new RawSourceBuilder(String.valueOf(f) + "f");
            }
            case Double: {
                return new RawSourceBuilder(metaValue.get(Double.class).toString());
            }
            case Bool: {
                return new RawSourceBuilder(metaValue.get(Boolean.class).toString());
            }
            case Long: {
                long l = metaValue.get(Long.class);
                return new RawSourceBuilder(String.valueOf(l) + "L");
            }
            case String: {
                String s = metaValue.get(String.class);
                return new RawSourceBuilder(CoreUtils.toStringLiteral(s));
            }
            case Type: {
                IType type = metaValue.get(IType.class);
                return ExpressionSourceBuilderFactory.createClassLiteral(SignatureUtils.getTypeSignature(type));
            }
            case Enum: {
                IField field = metaValue.get(IField.class);
                return ExpressionSourceBuilderFactory.createEnumValue(SignatureUtils.getTypeSignature(field.declaringType()), field.elementName());
            }
            case Annotation: {
                IAnnotation a = metaValue.get(IAnnotation.class);
                return new AnnotationSourceBuilder(a);
            }
            case Array: {
                IMetaValue[] metaArray = ((IArrayMetaValue)metaValue).metaValueArray();
                int n = metaArray.length;
                boolean useNewlines = n > 0 && (metaArray[0].type() == MetaValueType.Array || metaArray[0].type() == MetaValueType.Annotation);
                ArrayList<ISourceBuilder> sourceBuilderList = new ArrayList<ISourceBuilder>(n);
                IMetaValue[] iMetaValueArray = metaArray;
                int n2 = metaArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IMetaValue metaElement = iMetaValueArray[n3];
                    sourceBuilderList.add(ExpressionSourceBuilderFactory.createFromMetaValue(metaElement));
                    ++n3;
                }
                return ExpressionSourceBuilderFactory.createArray(sourceBuilderList, useNewlines);
            }
        }
        return new RawSourceBuilder("UNKNOWN(" + (Object)((Object)metaValue.type()) + ", " + metaValue + ")");
    }
}

