/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.annotation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractJavaElementSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ExpressionSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class AnnotationSourceBuilder
extends AbstractJavaElementSourceBuilder
implements IAnnotationSourceBuilder {
    private final String m_name;
    private final Map<String, ISourceBuilder> m_values = new LinkedHashMap<String, ISourceBuilder>();

    public AnnotationSourceBuilder(IAnnotation annotation) {
        super(annotation);
        this.m_name = annotation.type().name();
        for (IAnnotationElement av : annotation.elements().values()) {
            if (av.isDefault()) continue;
            this.putElement(av.elementName(), ExpressionSourceBuilderFactory.createFromMetaValue(av.value()));
        }
    }

    public AnnotationSourceBuilder(String name) {
        super(Signature.getSimpleName(name));
        this.m_name = name;
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        super.createSource(source, lineDelimiter, context, validator);
        if (StringUtils.isEmpty((CharSequence)this.getName())) {
            throw new IllegalArgumentException("name required!");
        }
        source.append("@" + validator.useName(this.getName()));
        int numElements = this.m_values.size();
        if (numElements > 0) {
            source.append('(');
            if (numElements == 1 && this.m_values.containsKey("value")) {
                ISourceBuilder v = this.m_values.values().iterator().next();
                v.createSource(source, lineDelimiter, context, validator);
            } else {
                boolean useMultiLine = numElements > 4;
                int i = 0;
                for (Map.Entry<String, ISourceBuilder> e : this.m_values.entrySet()) {
                    source.append(e.getKey());
                    source.append(" = ");
                    e.getValue().createSource(source, lineDelimiter, context, validator);
                    if (i < numElements - 1) {
                        source.append(',');
                        if (useMultiLine) {
                            source.append(lineDelimiter);
                        } else {
                            source.append(' ');
                        }
                    }
                    ++i;
                }
            }
            source.append(')');
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public IAnnotationSourceBuilder putElement(String name, String javaSource) {
        this.putElement(name, new RawSourceBuilder(javaSource));
        return this;
    }

    @Override
    public IAnnotationSourceBuilder putElement(String name, ISourceBuilder value) {
        this.m_values.put(name, value);
        return this;
    }

    @Override
    public boolean removeElement(String name) {
        return this.m_values.remove(name) != null;
    }

    @Override
    public ISourceBuilder getElement(String name) {
        return this.m_values.get(name);
    }

    @Override
    public Map<String, ISourceBuilder> getElements() {
        return Collections.unmodifiableMap(this.m_values);
    }
}

