/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.compilationunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IImport;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureDescriptor;
import org.eclipse.scout.sdk.core.sourcebuilder.AbstractJavaElementSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitScopedImportCollector;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class CompilationUnitSourceBuilder
extends AbstractJavaElementSourceBuilder
implements ICompilationUnitSourceBuilder {
    private final String m_packageName;
    private final List<String> m_declaredImports = new ArrayList<String>();
    private final List<String> m_declaredStaticImports = new ArrayList<String>();
    private final List<ITypeSourceBuilder> m_types = new ArrayList<ITypeSourceBuilder>();
    private final List<ISourceBuilder> m_footerSourceBuilders = new ArrayList<ISourceBuilder>();
    private final Map<CompositeObject, ITypeSourceBuilder> m_sortedTypes = new TreeMap<CompositeObject, ITypeSourceBuilder>();

    public CompilationUnitSourceBuilder(ICompilationUnit element) {
        super(element);
        this.m_packageName = element.containingPackage().elementName();
        for (IImport imp : element.imports()) {
            if (imp.isStatic()) {
                this.addDeclaredStaticImport(imp.elementName());
                continue;
            }
            this.addDeclaredImport(imp.elementName());
        }
        if (element.javaDoc().isAvailable()) {
            this.setComment(new RawSourceBuilder(element.javaDoc().toString()));
        }
        for (IType type : element.types().list()) {
            this.addType(new TypeSourceBuilder(type));
        }
    }

    public CompilationUnitSourceBuilder(String elementName, String packageName) {
        super(elementName);
        this.m_packageName = packageName;
    }

    @Override
    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        IImportCollector origImportCollector = validator.getImportCollector();
        CompilationUnitScopedImportCollector collector = new CompilationUnitScopedImportCollector(origImportCollector, this.getPackageName());
        validator.setImportCollector(collector);
        try {
            CompilationUnitSourceBuilder.consumeAllTypeNamesRec(this.m_types, collector);
            for (String s : this.m_declaredImports) {
                collector.addImport(s);
            }
            for (String s : this.m_declaredStaticImports) {
                collector.addStaticImport(s);
            }
            StringBuilder headerSourceBuilder = new StringBuilder();
            super.createSource(headerSourceBuilder, lineDelimiter, context, validator);
            if (!StringUtils.isEmpty((CharSequence)this.getPackageName())) {
                headerSourceBuilder.append("package ").append(this.getPackageName()).append(';').append(lineDelimiter).append(lineDelimiter);
            }
            StringBuilder typeSourceBuilder = new StringBuilder();
            for (ITypeSourceBuilder typeBuilder : this.getTypes()) {
                if (typeBuilder == null) continue;
                typeBuilder.createSource(typeSourceBuilder, lineDelimiter, context, validator);
            }
            List<String> importsToCreate = collector.createImportDeclarations();
            if (importsToCreate.size() > 0) {
                for (String imp : importsToCreate) {
                    headerSourceBuilder.append(imp).append(lineDelimiter);
                }
                headerSourceBuilder.append(lineDelimiter);
            }
            source.append((CharSequence)headerSourceBuilder);
            source.append((CharSequence)typeSourceBuilder);
            source.append(lineDelimiter);
            for (ISourceBuilder f : this.m_footerSourceBuilders) {
                f.createSource(source, lineDelimiter, context, validator);
            }
        }
        finally {
            validator.setImportCollector(origImportCollector);
        }
    }

    private static void consumeAllTypeNamesRec(Collection<ITypeSourceBuilder> typeBuilders, IImportCollector collector) {
        for (ITypeSourceBuilder typeSrc : typeBuilders) {
            String fqn = typeSrc.getFullyQualifiedName();
            collector.reserveElement(new SignatureDescriptor(Signature.createTypeSignature(fqn)));
            CompilationUnitSourceBuilder.consumeAllTypeNamesRec(typeSrc.getTypes(), collector);
        }
    }

    @Override
    public String getPackageName() {
        return this.m_packageName;
    }

    @Override
    public void addDeclaredImport(String name) {
        this.m_declaredImports.add(name);
    }

    @Override
    public boolean removeDeclaredStaticImport(String name) {
        return this.m_declaredStaticImports.remove(name);
    }

    @Override
    public boolean removeDeclaredImport(String name) {
        return this.m_declaredImports.remove(name);
    }

    @Override
    public void removeAllDeclaredImports() {
        this.m_declaredImports.clear();
    }

    @Override
    public void addDeclaredStaticImport(String name) {
        this.m_declaredStaticImports.add(name);
    }

    @Override
    public List<String> getDeclaredImports() {
        return Collections.unmodifiableList(this.m_declaredImports);
    }

    @Override
    public List<String> getDeclaredStaticImports() {
        return Collections.unmodifiableList(this.m_declaredStaticImports);
    }

    @Override
    public void addType(ITypeSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_sortedTypes.isEmpty()) {
            throw new IllegalStateException("This builder has already sorted inner type builders. A mix between sorted and unsorted inner type builders is not supported.");
        }
        this.m_types.add(builder);
        builder.setDeclaringElement(this);
    }

    @Override
    public void addSortedType(CompositeObject sortKey, ITypeSourceBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Source builder can not be null.");
        }
        if (!this.m_types.isEmpty()) {
            throw new IllegalStateException("This builder has already unsorted inner type builders. A mix between sorted and unsorted inner type builders is not supported.");
        }
        this.m_sortedTypes.put(sortKey, builder);
        builder.setDeclaringElement(this);
    }

    @Override
    public boolean removeType(String elementName) {
        ITypeSourceBuilder builder = null;
        Iterator<ITypeSourceBuilder> it = this.m_types.iterator();
        while (it.hasNext()) {
            builder = it.next();
            if (!elementName.equals(builder.getElementName())) continue;
            builder.setDeclaringElement(null);
            it.remove();
            return true;
        }
        it = this.m_sortedTypes.values().iterator();
        while (it.hasNext()) {
            builder = it.next();
            if (!elementName.equals(builder.getElementName())) continue;
            builder.setDeclaringElement(null);
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public ITypeSourceBuilder getMainType() {
        List<ITypeSourceBuilder> list = this.getTypes();
        if (list.isEmpty()) {
            return null;
        }
        String mainTypeName = this.getElementName();
        if (mainTypeName.toLowerCase().endsWith(".java")) {
            mainTypeName = mainTypeName.substring(0, mainTypeName.length() - ".java".length());
        }
        for (ITypeSourceBuilder sb : list) {
            if (!mainTypeName.equals(sb.getElementName())) continue;
            return sb;
        }
        return null;
    }

    @Override
    public List<ITypeSourceBuilder> getTypes() {
        ArrayList<ITypeSourceBuilder> builders = new ArrayList<ITypeSourceBuilder>(this.m_types.size() + this.m_sortedTypes.size());
        builders.addAll(this.m_types);
        builders.addAll(this.m_sortedTypes.values());
        return Collections.unmodifiableList(builders);
    }

    @Override
    public void addFooter(ISourceBuilder footerSourceBuilder) {
        this.m_footerSourceBuilders.add(footerSourceBuilder);
    }

    @Override
    public List<ISourceBuilder> getFooters() {
        return Collections.unmodifiableList(this.m_footerSourceBuilders);
    }
}

