/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.util.SdkConsole;

public final class SdkLog {
    public static final String LOG_LEVEL_PROPERTY_NAME = "org.eclipse.scout.sdk.propLogLevel";
    public static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    public static final String ARG_REPLACE_PATTERN = "{}";
    private static volatile Level curLevel = SdkLog.getInitialLogLevel();

    private SdkLog() {
    }

    public static void log(Level level, Object ... args) {
        SdkLog.log(level, null, args);
    }

    public static void log(Level level, String msg, Object ... args) {
        if (level == null) {
            level = DEFAULT_LOG_LEVEL;
        }
        if (level.intValue() < curLevel.intValue() || level.intValue() == Level.OFF.intValue()) {
            return;
        }
        StringBuilder message = new StringBuilder().append('[').append(level.getName()).append("]: ");
        int argStartIndex = 0;
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            StringBuilder messageBuilder = new StringBuilder(msg.length() + 50).append(msg);
            argStartIndex = SdkLog.handlePlaceholders(messageBuilder, args);
            message.append((CharSequence)messageBuilder);
        }
        SdkConsole.println(level, message.toString(), SdkLog.extractThrowables(argStartIndex, args));
    }

    static Throwable[] extractThrowables(int startIndex, Object ... args) {
        if (args == null || args.length <= startIndex) {
            return null;
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>(args.length - startIndex);
        int i = startIndex;
        while (i < args.length) {
            Object cur = args[i];
            SdkLog.searchForThrowables(cur, result);
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Throwable[result.size()]);
    }

    private static void searchForThrowables(Object o, Collection<Throwable> collector) {
        block4: {
            block5: {
                Object[] elements;
                block3: {
                    if (o == null) {
                        return;
                    }
                    if (!(o instanceof Throwable)) break block3;
                    collector.add((Throwable)o);
                    break block4;
                }
                if (!o.getClass().isArray()) break block5;
                Object[] objectArray = elements = (Object[])o;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    SdkLog.searchForThrowables(element, collector);
                    ++n2;
                }
                break block4;
            }
            if (!(o instanceof Iterable)) break block4;
            Iterable it = (Iterable)o;
            for (Object element : it) {
                SdkLog.searchForThrowables(element, collector);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static int handlePlaceholders(StringBuilder messageBuilder, Object[] args) {
        nextIndex = 0;
        lastPos = 0;
        curIndex = -1;
        if (args != null && args.length >= 1) ** GOTO lbl11
        return nextIndex;
lbl-1000:
        // 1 sources

        {
            endPos = curIndex + "{}".length();
            messageBuilder.replace(curIndex, endPos, SdkLog.toString(args[nextIndex]));
            ++nextIndex;
            lastPos = endPos;
lbl11:
            // 2 sources

            ** while ((curIndex = messageBuilder.indexOf((String)"{}", (int)lastPos)) >= 0 && nextIndex < args.length)
        }
lbl12:
        // 1 sources

        return nextIndex;
    }

    private static String toString(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return SdkLog.safeObjectToString(o);
        }
        Object[] arr = SdkLog.toObjectArray(o);
        if (arr.length < 1) {
            return "[]";
        }
        int maxSize = 100;
        int printSize = Math.min(arr.length, maxSize);
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append(SdkLog.toString(arr[0]));
        int i = 1;
        while (i < printSize) {
            b.append(", ");
            b.append(SdkLog.toString(arr[i]));
            ++i;
        }
        if (arr.length > maxSize) {
            b.append(",...");
        }
        b.append(']');
        return b.toString();
    }

    private static Object[] toObjectArray(Object arr) {
        if (arr instanceof Object[]) {
            return (Object[])arr;
        }
        if (arr instanceof boolean[]) {
            return ArrayUtils.toObject((boolean[])((boolean[])arr));
        }
        if (arr instanceof byte[]) {
            return ArrayUtils.toObject((byte[])((byte[])arr));
        }
        if (arr instanceof char[]) {
            return ArrayUtils.toObject((char[])((char[])arr));
        }
        if (arr instanceof short[]) {
            return ArrayUtils.toObject((short[])((short[])arr));
        }
        if (arr instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])arr));
        }
        if (arr instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])arr));
        }
        if (arr instanceof float[]) {
            return ArrayUtils.toObject((float[])((float[])arr));
        }
        if (arr instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])arr));
        }
        throw new IllegalArgumentException();
    }

    private static String safeObjectToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Throwable t) {
            System.err.println("Scout SdkLog: Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
            t.printStackTrace();
            return "[FAILED toString() of " + o.getClass() + ']';
        }
    }

    public static void debug(Object ... args) {
        SdkLog.debug(null, args);
    }

    public static void debug(String message, Object ... args) {
        SdkLog.log(Level.FINE, message, args);
    }

    public static void info(Object ... args) {
        SdkLog.info(null, args);
    }

    public static void info(String message, Object ... args) {
        SdkLog.log(Level.INFO, message, args);
    }

    public static void warning(Object ... args) {
        SdkLog.warning(null, args);
    }

    public static void warning(String message, Object ... args) {
        SdkLog.log(Level.WARNING, message, args);
    }

    public static void error(Object ... args) {
        SdkLog.error("", args);
    }

    public static void error(String message, Object ... args) {
        SdkLog.log(Level.SEVERE, message, args);
    }

    public static Level getLogLevel() {
        return curLevel;
    }

    public static void setLogLevel(Level newLevel) {
        curLevel = (Level)Validate.notNull((Object)newLevel);
    }

    public static void setLogLevel(String newLevelName) {
        curLevel = SdkLog.parseLevel(newLevelName);
    }

    public static void setInitialLogLevel() {
        SdkLog.setLogLevel(SdkLog.getInitialLogLevel());
    }

    public static boolean isLevelEnabled(Level level) {
        if (level == null) {
            return false;
        }
        return SdkLog.isLevelEnabled(level.intValue());
    }

    public static boolean isLevelEnabled(int level) {
        return SdkLog.getLogLevel().intValue() <= level;
    }

    public static boolean isDebugEnabled() {
        return SdkLog.isLevelEnabled(Level.FINE);
    }

    public static boolean isInfoEnabled() {
        return SdkLog.isLevelEnabled(Level.INFO);
    }

    public static boolean isWarningEnabled() {
        return SdkLog.isLevelEnabled(Level.WARNING);
    }

    public static boolean isErrorEnabled() {
        return SdkLog.isLevelEnabled(Level.SEVERE);
    }

    static Level parseLevel(String lvl) {
        if (StringUtils.isBlank((CharSequence)lvl)) {
            return DEFAULT_LOG_LEVEL;
        }
        try {
            Level parsedLevel = Level.parse(lvl);
            if (parsedLevel != null) {
                return parsedLevel;
            }
        }
        catch (Exception e) {
            SdkConsole.println(Level.SEVERE, "Unable to parse log level '" + lvl + "'. Fallback to default: '" + DEFAULT_LOG_LEVEL.getName() + "'.", e);
        }
        return DEFAULT_LOG_LEVEL;
    }

    static Level getInitialLogLevel() {
        String lvl = System.getProperty(LOG_LEVEL_PROPERTY_NAME);
        if (StringUtils.isBlank((CharSequence)lvl)) {
            return DEFAULT_LOG_LEVEL;
        }
        return SdkLog.parseLevel(lvl);
    }
}

