/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;

public abstract class REMAbstractBeanProxy
implements IREMBeanProxy {
    protected final REMProxyFactoryRegistry fFactory;
    private Integer fID;

    protected REMAbstractBeanProxy(REMProxyFactoryRegistry aRegistry, Integer anID) {
        this.fFactory = aRegistry;
        this.fID = anID;
    }

    public boolean equals(Object anObject) {
        if (super.equals(anObject)) {
            return true;
        }
        if (anObject instanceof IBeanProxy && !(anObject instanceof IREMConstantBeanProxy) && this.fFactory.isValid() && ((IBeanProxy)anObject).getProxyFactoryRegistry() == this.fFactory) {
            try {
                return ((IBooleanBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getObjectEquals().invoke((IBeanProxy)this, (IBeanProxy)anObject)).booleanValue();
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return false;
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        return this == aBeanProxy;
    }

    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fFactory;
    }

    public Integer getID() {
        return this.fID;
    }

    public boolean isValid() {
        return this.fID != null;
    }

    public void release() {
        this.fID = null;
    }

    public String toBeanString() {
        IStringBeanProxy string = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getObjectToString().invokeCatchThrowableExceptions(this);
        return string != null ? string.stringValue() : null;
    }

    public void renderBean(Commands.ValueObject value) {
        value.setObjectID(this.isValid() ? this.getID() : 0);
    }

    public final boolean isBeanProxy() {
        return true;
    }

    public final boolean isExpressionProxy() {
        return false;
    }
}

