/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.dto;

import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.AbstractDtoTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table.TableRowDataTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.util.DtoUtils;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.TypeFilters;

public abstract class AbstractTableBeanSourceBuilder
extends AbstractDtoTypeSourceBuilder {
    public AbstractTableBeanSourceBuilder(IType modelType, String targetPackageName, String typeName, IJavaEnvironment env, boolean setup) {
        super(modelType, targetPackageName, typeName, env, setup);
    }

    @Override
    protected void createContent() {
        super.createContent();
        IType table = CoreUtils.findInnerTypeInSuperHierarchy((IType)this.getModelType(), (Predicate)TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.ui.basic.table.ITable"));
        if (table != null) {
            this.visitTableBean(table);
        } else {
            this.addAbstractMethodImplementations();
        }
    }

    protected void visitTableBean(IType table) {
        String rowDataName = DtoUtils.getRowDataName(this.getElementName());
        TableRowDataTypeSourceBuilder tableRowDataBuilder = new TableRowDataTypeSourceBuilder(rowDataName, table, this.getModelType(), this.getJavaEnvironment());
        this.addSortedType(SortedMemberKeyFactory.createTypeTableKey((ITypeSourceBuilder)tableRowDataBuilder), (ITypeSourceBuilder)tableRowDataBuilder);
        final String tableRowSignature = Signature.createTypeSignature((String)rowDataName, (boolean)false);
        IMethodSourceBuilder getRowsMethodBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getRows");
        getRowsMethodBuilder.setReturnTypeSignature(Signature.createArraySignature((String)tableRowSignature, (int)1));
        getRowsMethodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return (").append(validator.useSignature(Signature.createArraySignature((String)tableRowSignature, (int)1))).append(") super.getRows();");
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)getRowsMethodBuilder), getRowsMethodBuilder);
        MethodSourceBuilder setRowsMethodBuilder = new MethodSourceBuilder("setRows");
        setRowsMethodBuilder.setFlags(1);
        setRowsMethodBuilder.setReturnTypeSignature("V");
        setRowsMethodBuilder.addParameter((IMethodParameterSourceBuilder)new MethodParameterSourceBuilder("rows", Signature.createArraySignature((String)tableRowSignature, (int)1)));
        setRowsMethodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("super.setRows(rows);");
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)setRowsMethodBuilder), (IMethodSourceBuilder)setRowsMethodBuilder);
        String addRowMethodName = "addRow";
        IMethodSourceBuilder addRowMethodBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"addRow", (Predicate)new Predicate<IMethod>(){

            @Override
            public boolean test(IMethod candidate) {
                return !candidate.parameters().existsAny();
            }
        });
        addRowMethodBuilder.setReturnTypeSignature(tableRowSignature);
        addRowMethodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return (").append(validator.useSignature(tableRowSignature)).append(") super.addRow();");
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)addRowMethodBuilder), addRowMethodBuilder);
        final IMethodSourceBuilder addRowWithStateMethodBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"addRow", (Predicate)new Predicate<IMethod>(){

            @Override
            public boolean test(IMethod candidate) {
                return candidate.parameters().list().size() == 1;
            }
        });
        ((IMethodParameterSourceBuilder)addRowWithStateMethodBuilder.getParameters().get(0)).setElementName("rowState");
        addRowWithStateMethodBuilder.setReturnTypeSignature(tableRowSignature);
        addRowWithStateMethodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return (").append(validator.useSignature(tableRowSignature)).append(") super.addRow(");
                source.append(((IMethodParameterSourceBuilder)addRowWithStateMethodBuilder.getParameters().get(0)).getElementName()).append(");");
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)addRowWithStateMethodBuilder), addRowWithStateMethodBuilder);
        final IMethodSourceBuilder rowAtMethodBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"rowAt");
        rowAtMethodBuilder.setReturnTypeSignature(tableRowSignature);
        ((IMethodParameterSourceBuilder)rowAtMethodBuilder.getParameters().get(0)).setElementName("index");
        rowAtMethodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return (").append(validator.useSignature(tableRowSignature)).append(") super.rowAt(").append(((IMethodParameterSourceBuilder)rowAtMethodBuilder.getParameters().get(0)).getElementName()).append(");");
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)rowAtMethodBuilder), rowAtMethodBuilder);
        IMethodSourceBuilder createRowMethodBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"createRow");
        createRowMethodBuilder.setReturnTypeSignature(tableRowSignature);
        if (Flags.isAbstract((int)table.flags()) || Flags.isAbstract((int)this.getModelType().flags())) {
            createRowMethodBuilder.setFlags(createRowMethodBuilder.getFlags() | 0x400);
        } else {
            createRowMethodBuilder.setBody(new ISourceBuilder(){

                public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                    source.append("return new ").append(validator.useSignature(tableRowSignature)).append("();");
                }
            });
        }
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)createRowMethodBuilder), createRowMethodBuilder);
        IMethodSourceBuilder getRowTypeMethodBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getRowType");
        getRowTypeMethodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return ").append(validator.useSignature(tableRowSignature)).append(SuffixConstants.SUFFIX_class).append(';');
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)getRowTypeMethodBuilder), getRowTypeMethodBuilder);
    }

    protected void addAbstractMethodImplementations() {
        IMethodSourceBuilder createRowSourceBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"createRow");
        createRowSourceBuilder.setReturnTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData"));
        createRowSourceBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return new ").append(validator.useName("org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData"));
                source.append("(){").append(lineDelimiter).append("private static final long serialVersionUID = 1L;").append(lineDelimiter).append("};");
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)createRowSourceBuilder), createRowSourceBuilder);
        IMethodSourceBuilder getRowTypeSourceBuilder = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)this, (String)this.getTargetPackage(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getRowType");
        getRowTypeSourceBuilder.setReturnTypeSignature(Signature.createTypeSignature((String)(String.valueOf(Class.class.getName()) + '<' + "? extends " + "org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData" + '>')));
        getRowTypeSourceBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append("return ").append(validator.useName("org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData")).append(SuffixConstants.SUFFIX_class).append(';');
            }
        });
        this.addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)getRowTypeSourceBuilder), getRowTypeSourceBuilder);
    }
}

