/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.s.annotation.ColumnDataAnnotation;
import org.eclipse.scout.sdk.core.s.model.ScoutTypeComparators;
import org.eclipse.scout.sdk.core.s.util.DtoUtils;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.core.util.TypeFilters;

public class TableRowDataTypeSourceBuilder
extends TypeSourceBuilder {
    protected static final int ROW_DATA_FIELD_FLAGS = 25;
    private final IType m_columnContainer;
    private final IType m_modelType;
    private final IJavaEnvironment m_lookpEnvironment;

    public TableRowDataTypeSourceBuilder(String elementName, IType columnContainer, IType modelType, IJavaEnvironment env) {
        super(elementName);
        this.m_columnContainer = columnContainer;
        this.m_modelType = modelType;
        this.m_lookpEnvironment = env;
    }

    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
        this.setup();
        super.createSource(source, lineDelimiter, context, validator);
    }

    private void setup() {
        IType rowDataSuperClassType = null;
        String rowDataSuperClassSig = this.computeTableRowDataSuperClassSignature();
        if (rowDataSuperClassSig != null) {
            rowDataSuperClassType = this.m_lookpEnvironment.findType(SignatureUtils.toFullyQualifiedName((String)Signature.getTypeErasure((String)rowDataSuperClassSig)));
        }
        int flags = 1;
        if (this.getDeclaringElement() instanceof ITypeSourceBuilder) {
            flags |= 8;
        }
        if (Flags.isAbstract((int)this.getColumnContainer().flags()) || Flags.isAbstract((int)this.getModelType().flags())) {
            flags |= 0x400;
        }
        this.setFlags(flags);
        this.setSuperTypeSignature(rowDataSuperClassSig);
        if (rowDataSuperClassSig == null) {
            this.addInterfaceSignature(Signature.createTypeSignature((String)Serializable.class.getName()));
        }
        IFieldSourceBuilder serialVersionUidBuilder = FieldSourceBuilderFactory.createSerialVersionUidBuilder();
        this.addSortedField(SortedMemberKeyFactory.createFieldSerialVersionUidKey((IFieldSourceBuilder)serialVersionUidBuilder), serialVersionUidBuilder);
        Set<IType> columns = TableRowDataTypeSourceBuilder.getColumns(this.getColumnContainer(), rowDataSuperClassType);
        int i = 0;
        for (IType column : columns) {
            String columnBeanName = TableRowDataTypeSourceBuilder.getColumnBeanName(column);
            String constantColName = columnBeanName;
            if (CoreUtils.isReservedJavaKeyword((String)constantColName)) {
                constantColName = String.valueOf(constantColName) + "_";
            }
            FieldSourceBuilder constantFieldBuilder = new FieldSourceBuilder(constantColName);
            constantFieldBuilder.setFlags(25);
            constantFieldBuilder.setSignature(Signature.createTypeSignature((String)String.class.getName()));
            constantFieldBuilder.setValue((ISourceBuilder)new RawSourceBuilder(CoreUtils.toStringLiteral((String)columnBeanName)));
            this.addSortedField(new CompositeObject(new Object[]{21, i, columnBeanName}), (IFieldSourceBuilder)constantFieldBuilder);
            FieldSourceBuilder memberFieldBuilder = new FieldSourceBuilder("m_" + columnBeanName);
            memberFieldBuilder.setFlags(2);
            String columnValueTypeSignature = DtoUtils.getColumnValueTypeSignature(column);
            if (columnValueTypeSignature == null) {
                SdkLog.warning((String)"Column '{}' has no value type.", (Object[])new Object[]{column.name()});
                columnValueTypeSignature = "Ljava.lang.Object;";
            }
            memberFieldBuilder.setSignature(columnValueTypeSignature);
            this.addSortedField(new CompositeObject(new Object[]{31, i, columnBeanName}), (IFieldSourceBuilder)memberFieldBuilder);
            IMethodSourceBuilder getterBuilder = MethodSourceBuilderFactory.createGetter((IFieldSourceBuilder)memberFieldBuilder);
            this.addSortedMethod(new CompositeObject(new Object[]{20, i, 1, getterBuilder}), getterBuilder);
            IMethodSourceBuilder setterBuilder = MethodSourceBuilderFactory.createSetter((String)memberFieldBuilder.getElementName(), (String)memberFieldBuilder.getSignature(), (int)1, (boolean)true, (String)"new");
            this.addSortedMethod(new CompositeObject(new Object[]{20, i, 2, setterBuilder}), setterBuilder);
            ++i;
        }
    }

    protected static String getColumnBeanName(IType column) {
        return CoreUtils.ensureStartWithLowerCase((String)DtoUtils.removeFieldSuffix(column.elementName()));
    }

    protected static Set<IType> getColumns(IType declaringType, IType rowDataSuperType) {
        IType tableExtension;
        if (declaringType.isInstanceOf("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn")) {
            HashSet<IType> result = new HashSet<IType>(1);
            result.add(declaringType);
            return result;
        }
        if (declaringType.isInstanceOf("org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.IPageWithTableExtension") && (tableExtension = CoreUtils.findInnerTypeInSuperHierarchy((IType)declaringType, (Predicate)TypeFilters.instanceOf((String)"org.eclipse.scout.rt.client.extension.ui.basic.table.ITableExtension"))) != null) {
            declaringType = tableExtension;
        }
        Set<IType> allColumnsUpTheHierarchy = TableRowDataTypeSourceBuilder.collectColumnsInSuperHierarchy(declaringType);
        if (rowDataSuperType == null) {
            return allColumnsUpTheHierarchy;
        }
        Set<String> usedColumnBeanNames = TableRowDataTypeSourceBuilder.collectBeanNamesInRowDataSuperHierarchy(rowDataSuperType);
        Iterator<IType> allColumnsIterator = allColumnsUpTheHierarchy.iterator();
        while (allColumnsIterator.hasNext()) {
            IType col = allColumnsIterator.next();
            String beanName = TableRowDataTypeSourceBuilder.getColumnBeanName(col);
            if (!usedColumnBeanNames.contains(beanName)) continue;
            allColumnsIterator.remove();
        }
        return allColumnsUpTheHierarchy;
    }

    protected static Set<String> collectBeanNamesInRowDataSuperHierarchy(IType rowDataSuperType) {
        HashSet<String> usedColumnBeanNames = new HashSet<String>();
        IType currentRowDataSuperType = rowDataSuperType;
        while (currentRowDataSuperType != null && !"org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData".equals(currentRowDataSuperType.name())) {
            List columnFields = currentRowDataSuperType.fields().withFlags(25).list();
            for (IField column : columnFields) {
                IMetaValue val = column.constantValue();
                if (val == null || val.type() != MetaValueType.String) continue;
                usedColumnBeanNames.add((String)val.get(String.class));
            }
            currentRowDataSuperType = currentRowDataSuperType.superClass();
        }
        return usedColumnBeanNames;
    }

    protected static Set<IType> collectColumnsInSuperHierarchy(IType declaringType) {
        TreeSet<IType> allColumnsUpTheHierarchy = new TreeSet<IType>(ScoutTypeComparators.getOrderAnnotationComparator(false));
        Predicate<IType> filter = new Predicate<IType>(){

            @Override
            public boolean test(IType type) {
                ColumnDataAnnotation.SdkColumnCommand cmd = DtoUtils.getSdkColumnCommand(type);
                return cmd == null || cmd.equals((Object)ColumnDataAnnotation.SdkColumnCommand.CREATE);
            }
        };
        IType curTableType = declaringType;
        while (curTableType != null) {
            List columns = curTableType.innerTypes().withInstanceOf("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn").withFilter((Predicate)filter).list();
            allColumnsUpTheHierarchy.addAll(columns);
            curTableType = curTableType.superClass();
        }
        return allColumnsUpTheHierarchy;
    }

    protected String computeTableRowDataSuperClassSignature() {
        IType superType;
        IType innerType;
        if (this.m_columnContainer.isInstanceOf("org.eclipse.scout.rt.shared.extension.IExtension") || !(this.getDeclaringElement() instanceof ITypeSourceBuilder)) {
            return null;
        }
        ITypeSourceBuilder surroundingTableBeanSourceBuilder = (ITypeSourceBuilder)this.getDeclaringElement();
        String superTypeOfSurroundingTableBeanSourceBuilder = surroundingTableBeanSourceBuilder.getSuperTypeSignature();
        if (!Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.page.AbstractTablePageData").equals(superTypeOfSurroundingTableBeanSourceBuilder) && !Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData").equals(superTypeOfSurroundingTableBeanSourceBuilder) && (innerType = (superType = this.m_lookpEnvironment.findType(SignatureUtils.toFullyQualifiedName((String)superTypeOfSurroundingTableBeanSourceBuilder))).innerTypes().withInstanceOf("org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData").first()) != null) {
            return SignatureUtils.getTypeSignature((IType)innerType);
        }
        return Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData");
    }

    public IType getColumnContainer() {
        return this.m_columnContainer;
    }

    public IType getModelType() {
        return this.m_modelType;
    }
}

