/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.lookupcall;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.FieldSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class LookupCallSourceBuilder
extends AbstractEntitySourceBuilder {
    private String m_keyTypeSignature;
    private String m_superTypeSignature;
    private String m_lookupServiceIfcSignature;
    private String m_classIdValue;

    public LookupCallSourceBuilder(String elementName, String packageName, IJavaEnvironment javaEnvironment) {
        super(elementName, packageName, javaEnvironment);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder lookupCallBuilder = new TypeSourceBuilder(this.getEntityName());
        lookupCallBuilder.setComment(CommentSourceBuilderFactory.createDefaultTypeComment((ITypeSourceBuilder)lookupCallBuilder));
        lookupCallBuilder.setFlags(1);
        StringBuilder superTypeBuilder = new StringBuilder(SignatureUtils.toFullyQualifiedName((String)this.getSuperTypeSignature()));
        superTypeBuilder.append('<');
        superTypeBuilder.append(SignatureUtils.toFullyQualifiedName((String)this.getKeyTypeSignature()));
        superTypeBuilder.append('>');
        lookupCallBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeBuilder.toString()));
        this.addType((ITypeSourceBuilder)lookupCallBuilder);
        if (StringUtils.isNotBlank((CharSequence)this.getClassIdValue())) {
            lookupCallBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createClassId(this.getClassIdValue()));
        }
        lookupCallBuilder.addField(FieldSourceBuilderFactory.createSerialVersionUidBuilder());
        if (StringUtils.isNotBlank((CharSequence)this.getLookupServiceIfcSignature())) {
            IMethodSourceBuilder getConfiguredService = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)lookupCallBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getConfiguredService");
            getConfiguredService.setBody(new ISourceBuilder(){

                public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                    source.append("return ").append(validator.useSignature(LookupCallSourceBuilder.this.getLookupServiceIfcSignature())).append(SuffixConstants.SUFFIX_class).append(';');
                }
            });
            getConfiguredService.removeAnnotation("org.eclipse.scout.rt.platform.Order");
            getConfiguredService.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigProperty");
            lookupCallBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodGetConfiguredKey((IMethodSourceBuilder)getConfiguredService), getConfiguredService);
        }
    }

    public String getKeyTypeSignature() {
        return this.m_keyTypeSignature;
    }

    public void setKeyTypeSignature(String keyTypeSignature) {
        this.m_keyTypeSignature = keyTypeSignature;
    }

    public String getSuperTypeSignature() {
        return this.m_superTypeSignature;
    }

    public void setSuperTypeSignature(String superTypeSignature) {
        this.m_superTypeSignature = superTypeSignature;
    }

    public String getLookupServiceIfcSignature() {
        return this.m_lookupServiceIfcSignature;
    }

    public void setLookupServiceIfcSignature(String lookupServiceIfcSignature) {
        this.m_lookupServiceIfcSignature = lookupServiceIfcSignature;
    }

    public String getClassIdValue() {
        return this.m_classIdValue;
    }

    public void setClassIdValue(String classIdValue) {
        this.m_classIdValue = classIdValue;
    }
}

