/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CreateMultipleSourceFoldersDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;

public class SourceContainerWorkbookPage
extends BuildPathBasePage {
    private final ListDialogField<CPListElement> fClassPathList;
    private IJavaProject fCurrJProject;
    private Control fSWTControl;
    private final TreeListDialogField<CPListElement> fFoldersList;
    private final StringDialogField fOutputLocationField;
    private final SelectionButtonDialogField fUseFolderOutputs;
    private final int IDX_ADD = 0;
    private final int IDX_ADD_LINK = 1;
    private final int IDX_EDIT = 3;
    private final int IDX_REMOVE = 4;

    private static AddSourceFolderWizard newSourceFolderWizard(CPListElement element, List<CPListElement> existingElements, String outputLocation, boolean newFolder) {
        CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, new Path(outputLocation).makeAbsolute(), false, newFolder, newFolder, newFolder ? CPListElement.isProjectSourceFolder(existing, element.getJavaProject()) : false, newFolder);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private static AddSourceFolderWizard newLinkedSourceFolderWizard(CPListElement element, List<CPListElement> existingElements, String outputLocation, boolean newFolder) {
        CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, new Path(outputLocation).makeAbsolute(), true, newFolder, newFolder, newFolder ? CPListElement.isProjectSourceFolder(existing, element.getJavaProject()) : false, newFolder);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private static EditFilterWizard newEditFilterWizard(CPListElement element, List<CPListElement> existingElements, String outputLocation) {
        CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
        EditFilterWizard result = new EditFilterWizard(existing, element, new Path(outputLocation).makeAbsolute());
        result.setDoFlushChange(false);
        return result;
    }

    public SourceContainerWorkbookPage(ListDialogField<CPListElement> classPathList, StringDialogField outputLocationField) {
        this.fClassPathList = classPathList;
        this.fOutputLocationField = outputLocationField;
        this.fSWTControl = null;
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.SourceContainerWorkbookPage_folders_add_button;
        stringArray[1] = NewWizardMessages.SourceContainerWorkbookPage_folders_link_source_button;
        stringArray[3] = NewWizardMessages.SourceContainerWorkbookPage_folders_edit_button;
        stringArray[4] = NewWizardMessages.SourceContainerWorkbookPage_folders_remove_button;
        String[] buttonLabels = stringArray;
        this.fFoldersList = new TreeListDialogField<CPListElement>(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener(adapter);
        this.fFoldersList.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_label);
        this.fFoldersList.setViewerComparator(new CPListElementSorter());
        this.fFoldersList.enableButton(3, false);
        this.fUseFolderOutputs = new SelectionButtonDialogField(32);
        this.fUseFolderOutputs.setSelection(false);
        this.fUseFolderOutputs.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_check);
        this.fUseFolderOutputs.setDialogFieldListener(adapter);
    }

    @Override
    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateFoldersList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SourceContainerWorkbookPage.this.updateFoldersList();
                }
            });
        }
    }

    private void updateFoldersList() {
        CPListElement cpe;
        if (this.fSWTControl == null || this.fSWTControl.isDisposed()) {
            return;
        }
        ArrayList<CPListElement> folders = new ArrayList<CPListElement>();
        boolean useFolderOutputs = false;
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        int i = 0;
        while (i < cpelements.size()) {
            cpe = cpelements.get(i);
            if (cpe.getEntryKind() == 3) {
                boolean hasOutputFolder;
                folders.add(cpe);
                boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
                if (hasOutputFolder) {
                    useFolderOutputs = true;
                }
            }
            ++i;
        }
        this.fFoldersList.setElements(folders);
        this.fUseFolderOutputs.setSelection(useFolderOutputs);
        i = 0;
        while (i < folders.size()) {
            boolean hasOutputFolder;
            cpe = (CPListElement)folders.get(i);
            IPath[] ePatterns = (IPath[])cpe.getAttribute("exclusion");
            IPath[] iPatterns = (IPath[])cpe.getAttribute("inclusion");
            boolean bl = hasOutputFolder = cpe.getAttribute("output") != null;
            if (ePatterns.length > 0 || iPatterns.length > 0 || hasOutputFolder) {
                this.fFoldersList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    @Override
    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fFoldersList, this.fUseFolderOutputs, this.fOutputLocationField}, true, -1, -1);
        BidiUtils.applyBidiProcessing((Text)this.fOutputLocationField.getTextControl(null), (String)"file");
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        List<CPListElement> elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPListElement elem = elements.get(i);
            IPath[] exclusionPatterns = (IPath[])elem.getAttribute("exclusion");
            IPath[] inclusionPatterns = (IPath[])elem.getAttribute("inclusion");
            IPath output = (IPath)elem.getAttribute("output");
            if (exclusionPatterns.length > 0 || inclusionPatterns.length > 0 || output != null) {
                this.fFoldersList.expandElement(elem, 3);
            }
            ++i;
        }
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField<CPListElement> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField<CPListElement> field) {
        List<Object> selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == 0) {
                IProject project = this.fCurrJProject.getProject();
                if (project.isAccessible() && this.hasFolders((IContainer)project)) {
                    List<CPListElement> existingElements = this.fFoldersList.getElements();
                    CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
                    CreateMultipleSourceFoldersDialog dialog = new CreateMultipleSourceFoldersDialog(this.fCurrJProject, existing, this.fOutputLocationField.getText(), this.getShell());
                    if (dialog.open() == 0) {
                        this.refresh(dialog.getInsertedElements(), dialog.getRemovedElements(), dialog.getModifiedElements(), dialog.getOutputLocation());
                    }
                } else {
                    CPListElement newElement = new CPListElement(this.fCurrJProject, 3);
                    AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newSourceFolderWizard(newElement, this.fFoldersList.getElements(), this.fOutputLocationField.getText(), true);
                    OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
                    action.run();
                }
            } else if (index == 1) {
                CPListElement newElement = new CPListElement(this.fCurrJProject, 3);
                AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(newElement, this.fFoldersList.getElements(), this.fOutputLocationField.getText(), true);
                OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
                action.run();
            } else if (index == 3) {
                this.editEntry();
            } else if (index == 4) {
                this.removeEntry();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFolders(IContainer container) {
        List<CPListElement> elements;
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IContainer) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        if ((elements = this.fFoldersList.getElements()).size() > 1) {
            return true;
        }
        if (elements.size() == 0) {
            return false;
        }
        CPListElement single = elements.get(0);
        return !single.getPath().equals((Object)this.fCurrJProject.getPath());
    }

    private void editEntry() {
        List<Object> selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editElementEntry(CPListElement elem) {
        if (elem.getLinkTarget() != null) {
            AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(elem, this.fFoldersList.getElements(), this.fOutputLocationField.getText(), false);
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
        } else {
            AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newSourceFolderWizard(elem, this.fFoldersList.getElements(), this.fOutputLocationField.getText(), false);
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("output")) {
            CPListElement selElement = elem.getParent();
            OutputLocationDialog dialog = new OutputLocationDialog(this.getShell(), selElement, this.fClassPathList.getElements(), new Path(this.fOutputLocationField.getText()).makeAbsolute(), true);
            if (dialog.open() == 0) {
                selElement.setAttribute("output", dialog.getOutputLocation());
                this.fFoldersList.refresh();
                this.fClassPathList.dialogFieldChanged();
            }
        } else if (key.equals("exclusion") || key.equals("inclusion")) {
            EditFilterWizard wizard = SourceContainerWorkbookPage.newEditFilterWizard(elem.getParent(), this.fFoldersList.getElements(), this.fOutputLocationField.getText());
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
        } else if (key.equals("ignore_optional_problems")) {
            String newValue = "true".equals(elem.getValue()) ? null : "true";
            elem.setValue(newValue);
            this.fFoldersList.refresh(elem);
        } else if (this.editCustomAttribute(this.getShell(), elem)) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List<Object> selected = this.fFoldersList.getSelectedElements();
        boolean isIgnoreOptionalProblems = selected.size() == 1 && selected.get(0) instanceof CPListElementAttribute && "ignore_optional_problems".equals(((CPListElementAttribute)selected.get(0)).getKey());
        this.fFoldersList.getButton(3).setText(isIgnoreOptionalProblems ? NewWizardMessages.SourceContainerWorkbookPage_folders_toggle_button : NewWizardMessages.SourceContainerWorkbookPage_folders_edit_button);
        this.fFoldersList.enableButton(3, this.canEdit(selected));
        this.fFoldersList.enableButton(4, this.canRemove(selected));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selected);
        this.fFoldersList.enableButton(0, noAttributes);
    }

    private void removeEntry() {
        List<Object> selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object object = selElements.get(i);
            if (object instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)object;
                String key = attrib.getKey();
                if (attrib.isBuiltIn()) {
                    Path[] value = null;
                    if (key.equals("exclusion") || key.equals("inclusion")) {
                        value = new Path[]{};
                    }
                    attrib.getParent().setAttribute(key, value);
                } else {
                    this.removeCustomAttribute(attrib);
                }
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            for (CPListElement cPListElement : selElements) {
                if (cPListElement.getEntryKind() != 3) continue;
                List<CPListElement> list = ClasspathModifier.removeFilters(cPListElement.getPath(), this.fCurrJProject, this.fFoldersList.getElements());
                for (CPListElement modified : list) {
                    this.fFoldersList.refresh(modified);
                    this.fFoldersList.expandElement(modified, 3);
                }
            }
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List<Object> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                if (attrib.isBuiltIn() ? ("inclusion".equals(key) ? ((IPath[])attrib.getValue()).length == 0 : ("exclusion".equals(key) ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null)) : !this.canRemoveCustomAttribute(attrib)) {
                    return false;
                }
            } else if (elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List<Object> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement cp = (CPListElement)elem;
            return !cp.getPath().equals((Object)cp.getJavaProject().getPath());
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            if (attrib.isBuiltIn()) {
                return true;
            }
            if ("ignore_optional_problems".equals(attrib.getKey())) {
                return true;
            }
            return this.canEditCustomAttribute(attrib);
        }
        return false;
    }

    private void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fUseFolderOutputs) {
            if (!this.fUseFolderOutputs.isSelected()) {
                int nFolders = this.fFoldersList.getSize();
                int i = 0;
                while (i < nFolders) {
                    CPListElement cpe = this.fFoldersList.getElement(i);
                    cpe.setAttribute("output", null);
                    ++i;
                }
            }
            this.fFoldersList.refresh();
            this.fFoldersList.dialogFieldChanged();
        } else if (field == this.fFoldersList) {
            this.updateClasspathList();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List<CPListElement> srcelements = this.fFoldersList.getElements();
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        if (lastRemovePos != nEntries || !srcelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    public List<Object> getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements, boolean expand) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fFoldersList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    private void refresh(List<CPListElement> insertedElements, List<?> removedElements, List<CPListElement> modifiedElements, IPath outputLocation) {
        this.fFoldersList.addElements(insertedElements);
        for (CPListElement element : insertedElements) {
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.removeElements(removedElements);
        for (CPListElement element : modifiedElements) {
            this.fFoldersList.refresh(element);
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.refresh();
        if (!insertedElements.isEmpty()) {
            this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(insertedElements));
        }
        this.fOutputLocationField.setText(outputLocation.makeRelative().toOSString());
    }

    @Override
    public void setFocus() {
        this.fFoldersList.setFocus();
    }

    private class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements IPropertyChangeListener {
        private final BuildPathWizard fWizard;
        private final List<Object> fSelectedElements;

        public OpenBuildPathWizardAction(BuildPathWizard wizard) {
            this.fWizard = wizard;
            this.addPropertyChangeListener(this);
            this.fSelectedElements = SourceContainerWorkbookPage.this.fFoldersList.getSelectedElements();
        }

        @Override
        protected INewWizard createWizard() throws CoreException {
            return this.fWizard;
        }

        @Override
        protected Shell getShell() {
            return SourceContainerWorkbookPage.this.getShell();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("result")) {
                if (event.getNewValue().equals(Boolean.TRUE)) {
                    this.finishWizard();
                } else {
                    this.fWizard.cancel();
                }
            }
        }

        protected void finishWizard() {
            List<CPListElement> insertedElements = this.fWizard.getInsertedElements();
            SourceContainerWorkbookPage.this.refresh(insertedElements, this.fWizard.getRemovedElements(), this.fWizard.getModifiedElements(), this.fWizard.getOutputLocation());
            if (insertedElements.isEmpty()) {
                SourceContainerWorkbookPage.this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(this.fSelectedElements));
            }
        }
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter<CPListElement>,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private SourceContainerAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPListElement> field, int index) {
            SourceContainerWorkbookPage.this.sourcePageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPListElement> field) {
            SourceContainerWorkbookPage.this.sourcePageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPListElement> field) {
            SourceContainerWorkbookPage.this.sourcePageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPListElement> field, KeyEvent event) {
            SourceContainerWorkbookPage.this.sourcePageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPListElement> field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(!SourceContainerWorkbookPage.this.fUseFolderOutputs.isSelected());
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField<CPListElement> field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPListElement> field, Object element) {
            return element instanceof CPListElement;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

