/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.JavaModelPrinter;
import org.eclipse.scout.sdk.core.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.sugar.AbstractManagedAnnotation;

public class AnnotationImplementor
extends AbstractJavaElementImplementor<AnnotationSpi>
implements IAnnotation {
    private Map<String, IAnnotationElement> m_values;

    public AnnotationImplementor(AnnotationSpi spi) {
        super(spi);
    }

    @Override
    public String name() {
        return this.type().name();
    }

    @Override
    public IType type() {
        return ((AnnotationSpi)this.m_spi).getType().wrap();
    }

    @Override
    public IAnnotationElement element(String name) {
        return this.elements().get(name);
    }

    @Override
    public Map<String, IAnnotationElement> elements() {
        if (this.m_values == null) {
            Set<Map.Entry<String, AnnotationElementSpi>> entrySet = ((AnnotationSpi)this.m_spi).getValues().entrySet();
            LinkedHashMap<String, IAnnotationElement> values = new LinkedHashMap<String, IAnnotationElement>(entrySet.size());
            Iterator<Map.Entry<String, AnnotationElementSpi>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                AnnotationElementSpi spiValue;
                Map.Entry<String, AnnotationElementSpi> e;
                values.put(e.getKey(), (spiValue = (e = iterator.next()).getValue()) != null ? spiValue.wrap() : null);
            }
            this.m_values = values;
        }
        return this.m_values;
    }

    @Override
    public IAnnotatable owner() {
        return ((AnnotationSpi)this.m_spi).getOwner().wrap();
    }

    @Override
    public <A extends AbstractManagedAnnotation> A wrap(Class<A> managedAnnotationType) {
        return AbstractManagedAnnotation.wrap(this, managedAnnotationType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        JavaModelPrinter.print(this, sb);
        return sb.toString();
    }
}

