/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.IPropertyBean;
import org.eclipse.scout.sdk.core.model.api.IType;

public class PropertyBean
implements IPropertyBean {
    private IMethod m_readMethod;
    private IMethod m_writeMethod;
    private String m_beanName;
    private final IType m_declaringType;

    public PropertyBean(IType declaringType, String beanName) {
        this.m_declaringType = declaringType;
        this.m_beanName = beanName;
    }

    public String toString() {
        return String.valueOf(this.m_declaringType.name()) + '#' + this.m_beanName;
    }

    @Override
    public IType declaringType() {
        return this.m_declaringType;
    }

    public void setBeanName(String beanName) {
        this.m_beanName = beanName;
    }

    @Override
    public String name() {
        return this.m_beanName;
    }

    @Override
    public IType type() {
        IMethodParameter parameter;
        if (this.m_readMethod != null) {
            return this.m_readMethod.returnType();
        }
        if (this.m_writeMethod != null && (parameter = this.m_writeMethod.parameters().first()) != null) {
            return parameter.dataType();
        }
        return null;
    }

    @Override
    public IMethod readMethod() {
        return this.m_readMethod;
    }

    @Override
    public IMethod writeMethod() {
        return this.m_writeMethod;
    }

    public void setReadMethod(IMethod readMethod) {
        this.m_readMethod = readMethod;
    }

    public void setWriteMethod(IMethod writeMethod) {
        this.m_writeMethod = writeMethod;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.m_beanName).append((Object)this.m_declaringType).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyBean other = (PropertyBean)obj;
        if (this.m_beanName == null ? other.m_beanName != null : !this.m_beanName.equals(other.m_beanName)) {
            return false;
        }
        return !(this.m_declaringType == null ? other.m_declaringType != null : !this.m_declaringType.equals(other.m_declaringType));
    }
}

