/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IPackage;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.signature.Signature;

public class UnresolvedTypeImplementor
implements IUnresolvedType {
    private final IType m_type;
    private final String m_name;
    private final IPackage m_package;
    private final String m_simpleName;
    private final IJavaEnvironment m_env;

    UnresolvedTypeImplementor(IType type) {
        this.m_type = type;
        this.m_name = type.name();
        this.m_package = type.compilationUnit().containingPackage();
        this.m_simpleName = type.elementName();
        this.m_env = type.javaEnvironment();
    }

    UnresolvedTypeImplementor(IJavaEnvironment env, String name) {
        this.m_type = null;
        this.m_name = name;
        this.m_env = env;
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            this.m_package = env.unwrap().getPackage(name.substring(0, dot)).wrap();
            this.m_simpleName = name.substring(dot + 1);
        } else {
            this.m_package = env.unwrap().getPackage(null).wrap();
            this.m_simpleName = name;
        }
    }

    @Override
    public IJavaEnvironment javaEnvironment() {
        return this.m_env;
    }

    @Override
    public String name() {
        return this.m_name;
    }

    @Override
    public IPackage containingPackage() {
        return this.m_package;
    }

    @Override
    public String elementName() {
        return this.m_simpleName;
    }

    @Override
    public String signature() {
        return Signature.createTypeSignature(this.name());
    }

    @Override
    public boolean exists() {
        return this.type() != null;
    }

    @Override
    public IType type() {
        return this.m_type;
    }

    public String toString() {
        return this.name();
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedTypeImplementor other = (UnresolvedTypeImplementor)obj;
        return this.name().equals(other.name());
    }

    @Override
    public ISourceRange source() {
        if (this.type() != null) {
            return this.type().source();
        }
        return ISourceRange.NO_SOURCE;
    }

    @Override
    public TypeSpi unwrap() {
        if (this.type() != null) {
            return this.type().unwrap();
        }
        return null;
    }
}

