/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.MethodParameterImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class DeclarationMethodParameterWithJdt
extends AbstractJavaElementWithJdt<IMethodParameter>
implements MethodParameterSpi {
    private final DeclarationMethodWithJdt m_declaringMethod;
    private final Argument m_astNode;
    private final int m_index;
    private String m_name;
    private TypeSpi m_dataType;
    private int m_flags;
    private List<DeclarationAnnotationWithJdt> m_annotations;
    private ISourceRange m_source;

    DeclarationMethodParameterWithJdt(JavaEnvironmentWithJdt env, DeclarationMethodWithJdt declaringMethod, Argument astNode, int index) {
        super(env);
        this.m_declaringMethod = (DeclarationMethodWithJdt)Validate.notNull((Object)declaringMethod);
        this.m_astNode = (Argument)Validate.notNull((Object)astNode);
        this.m_index = index;
        this.m_flags = -1;
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        MethodSpi newMethod = (MethodSpi)this.getDeclaringMethod().internalFindNewElement(newEnv);
        if (newMethod != null && newMethod.getParameters().size() > this.m_index) {
            return newMethod.getParameters().get(this.m_index);
        }
        return null;
    }

    @Override
    protected IMethodParameter internalCreateApi() {
        return new MethodParameterImplementor(this);
    }

    public Argument getInternalArgument() {
        return this.m_astNode;
    }

    @Override
    public DeclarationMethodWithJdt getDeclaringMethod() {
        return this.m_declaringMethod;
    }

    @Override
    public String getElementName() {
        if (this.m_name == null) {
            this.m_name = new String(this.m_astNode.name);
        }
        return this.m_name;
    }

    @Override
    public TypeSpi getDataType() {
        if (this.m_dataType == null) {
            if (this.m_astNode.type.resolvedType == null) {
                this.m_astNode.type.resolveType((BlockScope)this.m_declaringMethod.getInternalMethodDeclaration().scope);
            }
            this.m_dataType = SpiWithJdtUtils.bindingToType(this.m_env, this.m_astNode.type.resolvedType);
        }
        return this.m_dataType;
    }

    @Override
    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithJdtUtils.getMethodFlags(this.m_astNode.modifiers, false, SpiWithJdtUtils.hasDeprecatedAnnotation(this.m_astNode.annotations));
        }
        return this.m_flags;
    }

    public List<DeclarationAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        this.m_annotations = SpiWithJdtUtils.createDeclarationAnnotations(this.m_env, this, this.m_astNode.annotations);
        return this.m_annotations;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            CompilationUnitSpi cu = this.m_declaringMethod.getDeclaringType().getCompilationUnit();
            Argument decl = this.m_astNode;
            this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        }
        return this.m_source;
    }
}

