/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.model.api.IFileLocator;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.JavaEnvironmentImplementor;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractMemberWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.AstCompiler;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingArrayTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingBaseTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingFieldWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingMethodParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathBuilder;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationCompilationUnitWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationFieldWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationImportWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationMethodParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeParameterWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.DeclarationTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.FileSystemWithOverride;
import org.eclipse.scout.sdk.core.model.spi.internal.PackageWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SameCompositeObject;
import org.eclipse.scout.sdk.core.model.spi.internal.SourceRangeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;
import org.eclipse.scout.sdk.core.model.spi.internal.StringBasedJdtCompilationUnit;
import org.eclipse.scout.sdk.core.model.spi.internal.SyntheticCompilationUnitWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.VoidTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.WildcardOnlyTypeWithJdt;
import org.eclipse.scout.sdk.core.util.CompositeObject;

public class JavaEnvironmentWithJdt
implements JavaEnvironmentSpi {
    private static final Object NULL_OBJECT = new Object();
    private final IFileLocator m_fileLocator;
    private final Set<ClasspathEntry> m_classpaths;
    private final AstCompiler m_compiler;
    private final FileSystemWithOverride m_nameEnv;
    private final Map<Object, JavaElementSpi> m_compilerCache = new HashMap<Object, JavaElementSpi>();
    private final Map<Object, Object> m_performanceCache = new HashMap<Object, Object>();
    private final AtomicInteger m_hashSeq = new AtomicInteger();
    private IJavaEnvironment m_api;

    public JavaEnvironmentWithJdt(IFileLocator fileLocator, Path javaHome, Collection<ClasspathEntry> classpaths) {
        this.m_fileLocator = fileLocator;
        this.m_classpaths = new LinkedHashSet<ClasspathEntry>(classpaths);
        this.m_nameEnv = new FileSystemWithOverride(new ClasspathBuilder(javaHome, classpaths));
        this.m_compiler = new AstCompiler((INameEnvironment)this.m_nameEnv);
        this.m_api = new JavaEnvironmentImplementor(this);
    }

    @Override
    public IJavaEnvironment wrap() {
        return this.m_api;
    }

    @Override
    public PackageSpi getPackage(String name) {
        return this.createPackage(name);
    }

    protected CompositeObject createTypeKey(String fqn) {
        return new CompositeObject(TypeSpi.class, fqn);
    }

    @Override
    public synchronized TypeSpi findType(String fqn) {
        CompositeObject key = this.createTypeKey(fqn);
        Object elem = this.m_performanceCache.get(key);
        if (elem == null) {
            elem = this.doFindType(fqn);
            this.m_performanceCache.put(key, elem);
        }
        if (elem == NULL_OBJECT) {
            return null;
        }
        return (TypeSpi)elem;
    }

    protected Object doFindType(String fqn) {
        TypeSpi result = null;
        SpiWithJdtUtils.TypeDescriptor desc = SpiWithJdtUtils.getTypeDescriptor(fqn);
        TypeBinding binding = SpiWithJdtUtils.findTypeBinding(desc.m_primaryTypeName, this.m_compiler);
        if (binding != null) {
            TypeBinding b;
            result = desc.hasInnerType() ? SpiWithJdtUtils.bindingToInnerType(this, binding, desc.m_innerTypeNames) : SpiWithJdtUtils.bindingToType(this, binding);
            if (desc.m_arrayDimension > 0 && result instanceof AbstractTypeWithJdt && (b = ((AbstractTypeWithJdt)result).getInternalBinding()) != null) {
                result = SpiWithJdtUtils.bindingToType(this, (TypeBinding)this.m_compiler.lookupEnvironment.createArrayType(b, desc.m_arrayDimension));
            }
        }
        if (result == null) {
            return NULL_OBJECT;
        }
        return result;
    }

    @Override
    public IFileLocator getFileLocator() {
        return this.m_fileLocator;
    }

    @Override
    public JavaEnvironmentWithJdt emptyCopy() {
        List<ClasspathEntry> newClasspath = ((FileSystemWithOverride)this.m_compiler.lookupEnvironment.nameEnvironment).classpath().collect(Collectors.toList());
        JavaEnvironmentWithJdt newEnv = new JavaEnvironmentWithJdt(this.getFileLocator(), this.m_nameEnv.jreHome(), newClasspath);
        JavaEnvironmentWithJdt.copyCompilationUnitOverrides(this, newEnv);
        return newEnv;
    }

    protected static void copyCompilationUnitOverrides(JavaEnvironmentWithJdt src, JavaEnvironmentSpi dest) {
        for (ICompilationUnit cu : src.m_nameEnv.overrideSupport().getCompilationUnits()) {
            dest.registerCompilationUnitOverride(CharOperation.toString((char[][])cu.getPackageName()), new String(cu.getFileName()), cu.getContents());
        }
    }

    @Override
    public synchronized JavaEnvironmentSpi reload() {
        JavaEnvironmentWithJdt oldEnv = this;
        JavaEnvironmentWithJdt newEnv = this.emptyCopy();
        newEnv.m_api = oldEnv.m_api;
        ((JavaEnvironmentImplementor)newEnv.m_api).internalSetSpi(newEnv);
        JavaElementSpi[] oldSpiArray = oldEnv.m_compilerCache.values().toArray(new JavaElementSpi[oldEnv.m_compilerCache.size()]);
        JavaElementSpi[] newSpiArray = new JavaElementSpi[oldSpiArray.length];
        IJavaElement[] apiArray = new IJavaElement[oldSpiArray.length];
        int i = 0;
        while (i < apiArray.length) {
            apiArray[i] = oldSpiArray[i].wrap();
            if (apiArray[i] != null) {
                newSpiArray[i] = ((AbstractJavaElementWithJdt)oldSpiArray[i]).internalFindNewElement(newEnv);
            }
            ++i;
        }
        i = 0;
        while (i < apiArray.length) {
            if (apiArray[i] != null) {
                ((AbstractJavaElementImplementor)apiArray[i]).internalSetSpi(newSpiArray[i]);
                if (newSpiArray[i] != null) {
                    ((AbstractJavaElementWithJdt)newSpiArray[i]).internalSetApi(apiArray[i]);
                }
            }
            ++i;
        }
        return newEnv;
    }

    @Override
    public String getCompileErrors(String fqn) {
        TypeSpi typeSpi = this.findType(fqn);
        if (typeSpi == null) {
            throw new IllegalArgumentException("Cannot find type '" + fqn + "'.");
        }
        CompilationUnitSpi cuSpi = typeSpi.getCompilationUnit();
        if (!(cuSpi instanceof DeclarationCompilationUnitWithJdt)) {
            throw new IllegalArgumentException("Type '" + fqn + "' is not a source type.");
        }
        CompilationUnitDeclaration decl = ((DeclarationCompilationUnitWithJdt)cuSpi).getInternalCompilationUnitDeclaration();
        return this.m_compiler.getCompileErrors(decl);
    }

    @Override
    public synchronized boolean registerCompilationUnitOverride(String packageName, String fileName, char[] src) {
        Validate.notNull((Object)fileName);
        Validate.notNull((Object)src);
        StringBasedJdtCompilationUnit cu = new StringBasedJdtCompilationUnit(packageName, fileName, src);
        boolean reloadRequired = this.m_nameEnv.overrideSupport().addCompilationUnit(cu);
        String fqn = JavaEnvironmentWithJdt.getFqn(packageName, cu);
        this.m_performanceCache.remove(this.createTypeKey(fqn));
        if (!reloadRequired) {
            boolean bl = reloadRequired = this.m_compiler.lookupEnvironment.getCachedType(CharOperation.splitOn((char)'.', (char[])fqn.toCharArray())) != null;
        }
        if (!StringUtils.isEmpty((CharSequence)packageName)) {
            this.m_compiler.lookupEnvironment.createPackage(CharOperation.splitOn((char)'.', (char[])packageName.toCharArray()));
        }
        return reloadRequired;
    }

    protected static String getFqn(String packageName, ICompilationUnit cu) {
        StringBuilder fqnBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)packageName)) {
            fqnBuilder.append(packageName);
            fqnBuilder.append('.');
        }
        fqnBuilder.append(cu.getMainTypeName());
        return fqnBuilder.toString();
    }

    public int nextHashCode() {
        return this.m_hashSeq.getAndIncrement();
    }

    public ISourceRange getSource(CompilationUnitSpi cu, int start, int end) {
        ICompilationUnit sourceUnit;
        if (cu instanceof DeclarationCompilationUnitWithJdt && (sourceUnit = this.m_compiler.getSource(((DeclarationCompilationUnitWithJdt)cu).getInternalCompilationUnitDeclaration())) != null) {
            return new SourceRangeWithJdt(sourceUnit, start, end);
        }
        return ISourceRange.NO_SOURCE;
    }

    public Map<Object, Object> getPerformanceCache() {
        return this.m_performanceCache;
    }

    @Override
    public List<ClasspathSpi> getClasspath() {
        ArrayList<ClasspathSpi> list = new ArrayList<ClasspathSpi>(this.m_classpaths.size());
        for (ClasspathEntry cp : this.m_classpaths) {
            list.add(new ClasspathWithJdt(cp));
        }
        return list;
    }

    public synchronized VoidTypeWithJdt createVoidType() {
        Class<VoidTypeWithJdt> key = VoidTypeWithJdt.class;
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new VoidTypeWithJdt(this);
            this.m_compilerCache.put(key, elem);
        }
        return (VoidTypeWithJdt)elem;
    }

    public synchronized WildcardOnlyTypeWithJdt createWildcardOnlyType() {
        Class<WildcardOnlyTypeWithJdt> key = WildcardOnlyTypeWithJdt.class;
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new WildcardOnlyTypeWithJdt(this);
            this.m_compilerCache.put(key, elem);
        }
        return (WildcardOnlyTypeWithJdt)elem;
    }

    public synchronized BindingAnnotationWithJdt createBindingAnnotation(AnnotatableSpi owner, AnnotationBinding binding) {
        SameCompositeObject key = new SameCompositeObject(binding);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingAnnotationWithJdt(this, owner, binding);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingAnnotationWithJdt)elem;
    }

    public synchronized BindingAnnotationElementWithJdt createBindingAnnotationValue(BindingAnnotationWithJdt owner, ElementValuePair bindingPair, boolean syntheticDefaultValue) {
        SameCompositeObject key = new SameCompositeObject(owner, bindingPair);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingAnnotationElementWithJdt(this, owner, bindingPair, syntheticDefaultValue);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingAnnotationElementWithJdt)elem;
    }

    public synchronized BindingArrayTypeWithJdt createBindingArrayType(ArrayBinding binding, boolean isWildcard) {
        SameCompositeObject key = new SameCompositeObject(binding, isWildcard);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingArrayTypeWithJdt(this, binding, isWildcard);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingArrayTypeWithJdt)elem;
    }

    public synchronized BindingBaseTypeWithJdt createBindingBaseType(BaseTypeBinding binding) {
        SameCompositeObject key = new SameCompositeObject(binding);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingBaseTypeWithJdt(this, binding);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingBaseTypeWithJdt)elem;
    }

    public synchronized BindingFieldWithJdt createBindingField(AbstractTypeWithJdt declaringType, FieldBinding binding) {
        SameCompositeObject key = new SameCompositeObject(binding);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingFieldWithJdt(this, declaringType, binding);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingFieldWithJdt)elem;
    }

    public synchronized BindingMethodWithJdt createBindingMethod(BindingTypeWithJdt declaringType, MethodBinding binding) {
        SameCompositeObject key = new SameCompositeObject(binding);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingMethodWithJdt(this, declaringType, binding);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingMethodWithJdt)elem;
    }

    public synchronized BindingMethodParameterWithJdt createBindingMethodParameter(BindingMethodWithJdt declaringMethod, TypeBinding binding, char[] name, int index) {
        SameCompositeObject key = new SameCompositeObject(BindingMethodParameterWithJdt.class, declaringMethod, binding, index);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingMethodParameterWithJdt(this, declaringMethod, binding, name, index);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingMethodParameterWithJdt)elem;
    }

    public synchronized BindingTypeWithJdt createBindingType(ReferenceBinding binding, BindingTypeWithJdt declaringType, boolean isWildcard) {
        SameCompositeObject key = new SameCompositeObject(binding, isWildcard);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingTypeWithJdt(this, binding, declaringType, isWildcard);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingTypeWithJdt)elem;
    }

    public synchronized BindingTypeParameterWithJdt createBindingTypeParameter(AbstractMemberWithJdt<?> declaringMember, TypeVariableBinding binding, int index) {
        SameCompositeObject key = new SameCompositeObject(declaringMember, binding, index);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new BindingTypeParameterWithJdt(this, declaringMember, binding, index);
            this.m_compilerCache.put(key, elem);
        }
        return (BindingTypeParameterWithJdt)elem;
    }

    public synchronized DeclarationAnnotationWithJdt createDeclarationAnnotation(AnnotatableSpi owner, Annotation astNode) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationAnnotationWithJdt(this, owner, astNode);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationAnnotationWithJdt)elem;
    }

    public synchronized DeclarationAnnotationElementWithJdt createDeclarationAnnotationValue(DeclarationAnnotationWithJdt declaringAnnotation, MemberValuePair astNode, boolean syntheticDefaultValue) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationAnnotationElementWithJdt(this, declaringAnnotation, astNode, syntheticDefaultValue);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationAnnotationElementWithJdt)elem;
    }

    public synchronized DeclarationCompilationUnitWithJdt createDeclarationCompilationUnit(CompilationUnitDeclaration astNode) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationCompilationUnitWithJdt(this, astNode);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationCompilationUnitWithJdt)elem;
    }

    public synchronized DeclarationFieldWithJdt createDeclarationField(DeclarationTypeWithJdt declaringType, FieldDeclaration astNode) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationFieldWithJdt(this, declaringType, astNode);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationFieldWithJdt)elem;
    }

    public synchronized DeclarationImportWithJdt createDeclarationImport(DeclarationCompilationUnitWithJdt owner, ImportReference astNode) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationImportWithJdt(this, owner, astNode);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationImportWithJdt)elem;
    }

    public synchronized DeclarationMethodWithJdt createDeclarationMethod(DeclarationTypeWithJdt declaringType, AbstractMethodDeclaration astNode) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationMethodWithJdt(this, declaringType, astNode);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationMethodWithJdt)elem;
    }

    public synchronized DeclarationMethodParameterWithJdt createDeclarationMethodParameter(DeclarationMethodWithJdt declaringMethod, Argument astNode, int index) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationMethodParameterWithJdt(this, declaringMethod, astNode, index);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationMethodParameterWithJdt)elem;
    }

    public synchronized DeclarationTypeWithJdt createDeclarationType(CompilationUnitSpi cu, DeclarationTypeWithJdt declaringType, TypeDeclaration astNode) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationTypeWithJdt(this, cu, declaringType, astNode);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationTypeWithJdt)elem;
    }

    public synchronized DeclarationTypeParameterWithJdt createDeclarationTypeParameter(AbstractMemberWithJdt<?> declaringMember, TypeParameter astNode, int index) {
        SameCompositeObject key = new SameCompositeObject(astNode);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new DeclarationTypeParameterWithJdt(this, declaringMember, astNode, index);
            this.m_compilerCache.put(key, elem);
        }
        return (DeclarationTypeParameterWithJdt)elem;
    }

    public synchronized PackageWithJdt createPackage(String name) {
        CompositeObject key = new CompositeObject(PackageWithJdt.class, name);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new PackageWithJdt(this, name);
            this.m_compilerCache.put(key, elem);
        }
        return (PackageWithJdt)elem;
    }

    public PackageWithJdt createDefaultPackage() {
        return this.createPackage(null);
    }

    public synchronized SyntheticCompilationUnitWithJdt createSyntheticCompilationUnit(BindingTypeWithJdt mainType) {
        SameCompositeObject key = new SameCompositeObject(SyntheticCompilationUnitWithJdt.class, mainType);
        JavaElementSpi elem = this.m_compilerCache.get(key);
        if (elem == null) {
            elem = new SyntheticCompilationUnitWithJdt(this, mainType);
            this.m_compilerCache.put(key, elem);
        }
        return (SyntheticCompilationUnitWithJdt)elem;
    }
}

