/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.sugar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.model.api.IType;

public class SuperTypeQuery {
    private final IType m_type;
    private boolean m_includeSelf = true;
    private boolean m_includeSuperClasses = true;
    private boolean m_includeSuperInterfaces = true;
    private String m_name;
    private String m_simpleName;
    private int m_flags = -1;
    private Predicate<IType> m_filter;
    private int m_maxResultCount = Integer.MAX_VALUE;

    public SuperTypeQuery(IType type) {
        this.m_type = type;
    }

    public SuperTypeQuery withSelf(boolean b) {
        this.m_includeSelf = b;
        return this;
    }

    public SuperTypeQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public SuperTypeQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    public SuperTypeQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public SuperTypeQuery withFlags(int flags) {
        this.m_flags = flags;
        return this;
    }

    public SuperTypeQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    public SuperTypeQuery withSimpleName(String simpleName) {
        this.m_simpleName = simpleName;
        return this;
    }

    public SuperTypeQuery withFilter(Predicate<IType> filter) {
        this.m_filter = filter;
        return this;
    }

    public SuperTypeQuery withMaxResultCount(int maxResultCount) {
        this.m_maxResultCount = maxResultCount;
        return this;
    }

    protected boolean accept(IType t) {
        if (!this.m_includeSelf && this.m_type == t) {
            return false;
        }
        if (this.m_flags >= 0 && (t.flags() & this.m_flags) != this.m_flags) {
            return false;
        }
        if (this.m_name != null && !this.m_name.equals(t.name())) {
            return false;
        }
        if (this.m_simpleName != null && !this.m_simpleName.equals(t.elementName())) {
            return false;
        }
        return this.m_filter == null || this.m_filter.test(t);
    }

    protected void visitRec(IType t, Set<IType> result, int maxCount, boolean onlyTraverse) {
        if (t == null) {
            return;
        }
        if (!onlyTraverse && this.accept(t)) {
            result.add(t);
            if (result.size() >= maxCount) {
                return;
            }
        }
        if (this.m_includeSuperClasses || this.m_includeSuperInterfaces) {
            this.visitRec(t.superClass(), result, maxCount, !this.m_includeSuperClasses);
            if (result.size() >= maxCount) {
                return;
            }
        }
        if (this.m_includeSuperInterfaces) {
            for (IType superInterface : t.superInterfaces()) {
                this.visitRec(superInterface, result, maxCount, false);
                if (result.size() < maxCount) continue;
                return;
            }
        }
    }

    public boolean existsAny() {
        return this.first() != null;
    }

    public IType first() {
        HashSet<IType> result = new HashSet<IType>(1);
        this.visitRec(this.m_type, result, 1, false);
        return result.isEmpty() ? null : (IType)result.iterator().next();
    }

    public List<IType> list() {
        HashSet<IType> result = new HashSet<IType>();
        this.visitRec(this.m_type, result, this.m_maxResultCount, false);
        return new ArrayList<IType>(result);
    }
}

