/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.sourcebuilder.compilationunit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importcollector.WrappedImportCollector;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.signature.SignatureDescriptor;

public class CompilationUnitScopedImportCollector
extends WrappedImportCollector {
    private final String m_packageName;
    private final Map<String, Boolean> m_existsInSamePackageCache = new HashMap<String, Boolean>();

    public CompilationUnitScopedImportCollector(IImportCollector inner, String packageName) {
        super(inner);
        this.m_packageName = packageName;
    }

    @Override
    public String getQualifier() {
        return this.m_packageName;
    }

    @Override
    public String checkCurrentScope(SignatureDescriptor cand) {
        String q = this.getQualifier();
        if (Objects.equals(this.getQualifier(), cand.getQualifier()) || StringUtils.isBlank((CharSequence)q) && StringUtils.isBlank((CharSequence)cand.getQualifier())) {
            return cand.getSimpleName();
        }
        IJavaEnvironment env = this.getJavaEnvironment();
        if (env != null) {
            Boolean existsInSamePackage = this.m_existsInSamePackageCache.get(cand.getSimpleName());
            if (existsInSamePackage == null) {
                String name = null;
                name = StringUtils.isEmpty((CharSequence)q) ? cand.getSimpleName() : this.getQualifier() + '.' + cand.getSimpleName();
                existsInSamePackage = env.findType(name) != null;
                this.m_existsInSamePackageCache.put(cand.getSimpleName(), existsInSamePackage);
            }
            if (existsInSamePackage.booleanValue()) {
                return cand.getQualifiedName();
            }
        }
        return super.checkCurrentScope(cand);
    }
}

