/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.scout.sdk.core.util.IWeakEventListener;

public class BasicPropertySupport {
    public static final int DEFAULT_INT_VALUE = 0;
    public static final int DEFAULT_DOUBLE_VALUE = 0;
    public static final Integer DEFAULT_INT = 0;
    public static final Double DEFAULT_DOUBLE = 0.0;
    public static final long DEFAULT_LONG_VALUE = 0L;
    public static final Long DEFAULT_LONG = 0L;
    public static final Boolean DEFAULT_BOOL = Boolean.FALSE;
    private final Map<String, Object> m_props;
    private final Object m_source;
    private final Object m_listenerLock;
    private List<Object> m_listeners;
    private Map<String, List<Object>> m_childListeners;
    private int m_propertiesChanging;
    private List<PropertyChangeEvent> m_propertyEventBuffer;

    public BasicPropertySupport(Object sourceBean) {
        this.m_source = sourceBean;
        this.m_props = new HashMap<String, Object>();
        this.m_listenerLock = new Object();
    }

    public boolean isPropertiesChanging() {
        return this.m_propertiesChanging > 0;
    }

    public void setPropertiesChanging(boolean b) {
        if (b) {
            ++this.m_propertiesChanging;
        } else if (this.m_propertiesChanging > 0) {
            --this.m_propertiesChanging;
            if (this.m_propertiesChanging == 0) {
                this.processChangeBuffer();
            }
        }
    }

    public void clearProperties() {
        this.m_props.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getPropertiesMap() {
        Object object = this.m_listenerLock;
        synchronized (object) {
            return new HashMap<String, Object>(this.m_props);
        }
    }

    public void putPropertiesMap(Map<String, Object> map) {
        this.m_props.putAll(map);
    }

    public boolean hasProperty(String name) {
        return this.m_props.containsKey(name);
    }

    public boolean setPropertyInt(String name, int i) {
        return this.setProperty(name, i, DEFAULT_INT);
    }

    public int getPropertyInt(String name) {
        Number n = (Number)this.getProperty(name);
        if (n == null) {
            return 0;
        }
        return n.intValue();
    }

    public boolean setPropertyDouble(String name, double d) {
        return this.setProperty(name, new Double(d), DEFAULT_DOUBLE);
    }

    public double getPropertyDouble(String name) {
        Number n = (Number)this.getProperty(name);
        if (n == null) {
            return 0.0;
        }
        return n.doubleValue();
    }

    public boolean setPropertyLong(String name, long i) {
        return this.setProperty(name, i, DEFAULT_LONG);
    }

    public long getPropertyLong(String name) {
        Number n = (Number)this.getProperty(name);
        if (n == null) {
            return 0L;
        }
        return n.longValue();
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.setProperty(name, b, DEFAULT_BOOL);
    }

    public boolean getPropertyBool(String name) {
        Boolean b = (Boolean)this.getProperty(name);
        if (b == null) {
            return DEFAULT_BOOL;
        }
        return b;
    }

    public boolean setPropertyString(String name, String s) {
        return this.setProperty(name, s);
    }

    public String getPropertyString(String name) {
        String s = (String)this.getProperty(name);
        return s;
    }

    public Object getProperty(String name) {
        return this.m_props.get(name);
    }

    public <T> boolean setPropertyList(String name, List<T> newValue) {
        return this.setPropertyList(name, newValue, false);
    }

    public <T> boolean setPropertyListAlwaysFire(String name, List<T> newValue) {
        return this.setPropertyList(name, newValue, true);
    }

    private <T> boolean setPropertyList(String name, List<T> newValue, boolean alwaysFire) {
        Object oldValue = this.m_props.get(name);
        boolean propChanged = this.setPropertyNoFire(name, newValue);
        if (propChanged || alwaysFire) {
            ArrayList eventOldValue = null;
            if (oldValue instanceof List) {
                eventOldValue = new ArrayList((List)oldValue);
            }
            ArrayList<T> eventNewValue = null;
            if (newValue != null) {
                eventNewValue = new ArrayList<T>(newValue);
            }
            this.firePropertyChangeImpl(name, eventOldValue, eventNewValue);
            return propChanged;
        }
        return false;
    }

    public <T> List<T> getPropertyList(String name) {
        return (List)this.m_props.get(name);
    }

    public <T> boolean setPropertySet(String name, Set<T> newValue) {
        return this.setPropertySet(name, newValue, false);
    }

    public <T> boolean setPropertySetAlwaysFire(String name, Set<T> newValue) {
        return this.setPropertySet(name, newValue, true);
    }

    private <T> boolean setPropertySet(String name, Set<T> newValue, boolean alwaysFire) {
        Object oldValue = this.m_props.get(name);
        boolean propChanged = this.setPropertyNoFire(name, newValue);
        if (propChanged || alwaysFire) {
            HashSet eventOldValue = null;
            if (oldValue instanceof Set) {
                eventOldValue = new HashSet((Set)oldValue);
            }
            HashSet<T> eventNewValue = null;
            if (newValue != null) {
                eventNewValue = new HashSet<T>(newValue);
            }
            this.firePropertyChangeImpl(name, eventOldValue, eventNewValue);
            return propChanged;
        }
        return false;
    }

    public <T> Set<T> getPropertySet(String name) {
        return (Set)this.m_props.get(name);
    }

    public boolean setProperty(String name, Object newValue) {
        return this.setProperty(name, newValue, null);
    }

    public boolean setPropertyNoFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        return !Objects.equals(oldValue, newValue);
    }

    public boolean setProperty(String name, Object newValue, Object defaultOldValueWhenNull) {
        Object oldValue = this.m_props.get(name);
        if (oldValue == null) {
            oldValue = defaultOldValueWhenNull;
        }
        this.m_props.put(name, newValue);
        if (Objects.equals(oldValue, newValue)) {
            return false;
        }
        this.firePropertyChangeImpl(name, oldValue, newValue);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_listeners == null) {
                    this.m_listeners = new ArrayList<Object>();
                }
                if (listener instanceof IWeakEventListener) {
                    this.m_listeners.add(new WeakReference<PropertyChangeListener>(listener));
                } else {
                    this.m_listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            Object object = this.m_listenerLock;
            synchronized (object) {
                BasicPropertySupport.removeFromListNoLock(this.m_listeners, listener);
                if (this.m_childListeners != null) {
                    for (List<Object> childList : this.m_childListeners.values()) {
                        BasicPropertySupport.removeFromListNoLock(childList, listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            List<Object> children;
            if (this.m_childListeners == null) {
                this.m_childListeners = new HashMap<String, List<Object>>();
            }
            if ((children = this.m_childListeners.get(propertyName)) == null) {
                children = new ArrayList<Object>();
                this.m_childListeners.put(propertyName, children);
            }
            if (listener instanceof IWeakEventListener) {
                children.add(new WeakReference<PropertyChangeListener>(listener));
            } else {
                children.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            List<Object> childList;
            if (this.m_childListeners != null && (childList = this.m_childListeners.get(propertyName)) != null) {
                BasicPropertySupport.removeFromListNoLock(childList, listener);
            }
        }
    }

    private static void removeFromListNoLock(List<Object> listeners, PropertyChangeListener listener) {
        if (listeners == null) {
            return;
        }
        if (listener instanceof IWeakEventListener) {
            int i = 0;
            int n = listeners.size();
            while (i < n) {
                Object o = listeners.get(i);
                if (o instanceof WeakReference && ((WeakReference)o).get() == listener) {
                    listeners.remove(i);
                    break;
                }
                ++i;
            }
        } else {
            listeners.remove(listener);
        }
        if (listeners.size() == 0 && listeners instanceof ArrayList) {
            ((ArrayList)listeners).trimToSize();
        }
    }

    public void firePropertyChange(PropertyChangeEvent e) {
        this.firePropertyChangeImpl(e);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    private void firePropertyChangeImpl(String propertyName, Object oldValue, Object newValue) {
        List<Object> l = this.m_listeners;
        Map<String, List<Object>> m = this.m_childListeners;
        if (l != null && l.size() > 0 || m != null && m.size() > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.m_source, propertyName, oldValue, newValue);
            this.firePropertyChangeImpl(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeImpl(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        if (this.isPropertiesChanging()) {
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_propertyEventBuffer == null) {
                    this.m_propertyEventBuffer = new ArrayList<PropertyChangeEvent>();
                }
                this.m_propertyEventBuffer.add(e);
            }
        }
        ArrayList<PropertyChangeListener> targets = new ArrayList<PropertyChangeListener>(4);
        Object object = this.m_listenerLock;
        synchronized (object) {
            List<Object> childListeners;
            String propertyName;
            if (this.m_listeners != null) {
                for (Object o : this.m_listeners) {
                    if (o instanceof WeakReference) {
                        o = ((WeakReference)o).get();
                    }
                    if (o == null) continue;
                    targets.add((PropertyChangeListener)o);
                }
            }
            if ((propertyName = e.getPropertyName()) != null && this.m_childListeners != null && (childListeners = this.m_childListeners.get(propertyName)) != null) {
                for (Object o : childListeners) {
                    if (o instanceof WeakReference) {
                        o = ((WeakReference)o).get();
                    }
                    if (o == null) continue;
                    targets.add((PropertyChangeListener)o);
                }
            }
        }
        if (targets.size() > 0) {
            for (PropertyChangeListener listener : targets) {
                listener.propertyChange(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangeBuffer() {
        PropertyChangeEvent[] a = null;
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_propertyEventBuffer != null) {
                a = this.m_propertyEventBuffer.toArray(new PropertyChangeEvent[this.m_propertyEventBuffer.size()]);
            }
            this.m_propertyEventBuffer = null;
        }
        if (a != null && a.length > 0) {
            LinkedList<PropertyChangeEvent> coalesceList = new LinkedList<PropertyChangeEvent>();
            HashSet<String> names = new HashSet<String>();
            int i = a.length - 1;
            while (i >= 0) {
                if (!names.contains(a[i].getPropertyName())) {
                    coalesceList.add(0, a[i]);
                    names.add(a[i].getPropertyName());
                }
                --i;
            }
            for (PropertyChangeEvent e : coalesceList) {
                this.firePropertyChangeImpl(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String propertyName) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            List<Object> l0 = this.m_listeners;
            List<Object> l1 = null;
            if (propertyName != null) {
                l1 = this.m_childListeners.get(propertyName);
            }
            int count = (l0 != null ? l0.size() : 0) + (l1 != null ? l1.size() : 0);
            return count > 0;
        }
    }
}

