/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.xml.sax.InputSource;

public class ParsedWsdl {
    private final Map<URI, String> m_referencedResourceUris = new HashMap<URI, String>();
    private final Map<Service, URI> m_services = new HashMap<Service, URI>();
    private final Map<PortType, URI> m_portTypes = new HashMap<PortType, URI>();
    private final Map<Service, Map<String, QName>> m_portTypesByService = new HashMap<Service, Map<String, QName>>();
    private final Map<Service, WebServiceNames> m_namesByService = new HashMap<Service, WebServiceNames>();

    protected ParsedWsdl() {
    }

    public Map<URI, String> getReferencedResources() {
        return Collections.unmodifiableMap(this.m_referencedResourceUris);
    }

    public Map<Service, URI> getWebServices() {
        return Collections.unmodifiableMap(this.m_services);
    }

    public Map<PortType, URI> getPortTypes() {
        return Collections.unmodifiableMap(this.m_portTypes);
    }

    public boolean isEmpty() {
        return this.m_portTypes.isEmpty();
    }

    public Set<PortType> getPortTypes(Service service) {
        Map<String, QName> portTypesByPort = this.m_portTypesByService.get(service);
        if (portTypesByPort == null || portTypesByPort.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<PortType> result = new HashSet<PortType>(portTypesByPort.size());
        for (QName portTypeName : portTypesByPort.values()) {
            PortType portType = this.getPortType(portTypeName);
            if (portType == null) continue;
            result.add(portType);
        }
        return result;
    }

    public Map<String, QName> getPorts(Service service) {
        Map<String, QName> map = this.m_portTypesByService.get(service);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public String getPortName(Service service, PortType portType) {
        QName nameToSearch = portType.getQName();
        for (Map.Entry<String, QName> entry : this.getPorts(service).entrySet()) {
            if (!entry.getValue().equals(nameToSearch)) continue;
            return entry.getKey();
        }
        return null;
    }

    public PortType getPortType(QName name) {
        for (PortType candidate : this.m_portTypes.keySet()) {
            if (!name.equals(candidate.getQName())) continue;
            return candidate;
        }
        return null;
    }

    public Map<Service, WebServiceNames> getServiceNames() {
        return Collections.unmodifiableMap(this.m_namesByService);
    }

    protected void putPortType(PortType portType, URI source) {
        this.m_portTypes.put(portType, source);
    }

    protected void putService(Service service, URI source) {
        this.m_services.put(service, source);
    }

    protected String putReferencedResource(URI absolutePath, URI pathFromWsdlRoot) throws UnsupportedEncodingException {
        return this.m_referencedResourceUris.put(absolutePath.normalize(), URLDecoder.decode(pathFromWsdlRoot.toString(), StandardCharsets.UTF_8.name()));
    }

    protected void completeMapping() {
        HashSet<Service> usedServices = new HashSet<Service>(this.m_services.size());
        HashSet<PortType> usedPortTypes = new HashSet<PortType>(this.m_portTypes.size());
        for (Service service : this.m_services.keySet()) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                for (ExtensibilityElement element : ParsedWsdl.extensibilityElementsOf((ElementExtensible)port)) {
                    PortType portType;
                    Binding binding;
                    if (!(element instanceof SOAPAddress) || !ParsedWsdl.isBindingSupported(binding = port.getBinding()) || (portType = binding.getPortType()) == null) continue;
                    usedServices.add(service);
                    usedPortTypes.add(portType);
                    Map<String, QName> portTypesByPortName = this.m_portTypesByService.get(service);
                    if (portTypesByPortName == null) {
                        portTypesByPortName = new HashMap<String, QName>();
                        this.m_portTypesByService.put(service, portTypesByPortName);
                    }
                    portTypesByPortName.put(port.getName(), portType.getQName());
                }
            }
        }
        this.m_portTypes.keySet().retainAll(usedPortTypes);
        this.m_services.keySet().retainAll(usedServices);
        for (Service s : this.m_services.keySet()) {
            this.m_namesByService.put(s, new WebServiceNames(s.getQName().getLocalPart()));
        }
    }

    protected static Definition parseWsdl(URI documentBase, InputSource wsdl) throws WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setFeature("javax.wsdl.verbose", false);
        String documentBaseUri = null;
        if (documentBase != null) {
            documentBaseUri = documentBase.toString();
        }
        return reader.readWSDL(documentBaseUri, wsdl);
    }

    public static ParsedWsdl create(URI documentBase, String wsdlContent, boolean loadSchemas) throws WSDLException, UnsupportedEncodingException {
        Definition wsdl = ParsedWsdl.parseWsdl(documentBase, new InputSource(new StringReader(wsdlContent)));
        return ParsedWsdl.create(wsdl, loadSchemas);
    }

    public static ParsedWsdl create(URI documentBase, InputStream is, boolean loadSchemas) throws WSDLException, UnsupportedEncodingException {
        Definition wsdl = ParsedWsdl.parseWsdl(documentBase, new InputSource((InputStream)Validate.notNull((Object)is)));
        return ParsedWsdl.create(wsdl, loadSchemas);
    }

    protected static ParsedWsdl create(Definition wsdl, boolean loadSchemas) throws UnsupportedEncodingException {
        if (wsdl == null) {
            return null;
        }
        ParsedWsdl result = new ParsedWsdl();
        URI rootDirUri = CoreUtils.getParentURI((URI)URI.create(wsdl.getDocumentBaseURI()));
        ParsedWsdl.parseWsdlRec(wsdl, rootDirUri, URI.create(""), result, loadSchemas);
        result.completeMapping();
        return result;
    }

    protected static boolean isBindingSupported(Binding b) {
        if (b == null) {
            return false;
        }
        List ops = b.getBindingOperations();
        if (ops.isEmpty()) {
            return false;
        }
        for (BindingOperation op : ops) {
            List<ExtensibilityElement> opElements = ParsedWsdl.extensibilityElementsOf((ElementExtensible)op);
            List<ExtensibilityElement> outputElements = ParsedWsdl.extensibilityElementsOf((ElementExtensible)op.getBindingOutput());
            List<ExtensibilityElement> inputElements = ParsedWsdl.extensibilityElementsOf((ElementExtensible)op.getBindingInput());
            ArrayList<ExtensibilityElement> all = new ArrayList<ExtensibilityElement>(opElements.size() + outputElements.size() + inputElements.size());
            all.addAll(opElements);
            all.addAll(outputElements);
            all.addAll(inputElements);
            for (ExtensibilityElement element : all) {
                if (!(element instanceof SOAPBody) || !"encoded".equalsIgnoreCase(((SOAPBody)element).getUse())) continue;
                return false;
            }
        }
        return true;
    }

    protected static List<ExtensibilityElement> extensibilityElementsOf(ElementExtensible e) {
        if (e == null) {
            return Collections.emptyList();
        }
        return e.getExtensibilityElements();
    }

    protected static void parseWsdlRec(Definition def, URI rootDefUri, URI relPath, ParsedWsdl collector, boolean loadSchemas) throws UnsupportedEncodingException {
        Map imports = def.getImports();
        for (List iv : imports.values()) {
            for (Import i : iv) {
                Definition innerDef = i.getDefinition();
                if (innerDef == null) continue;
                URI pathRelativeToRoot = relPath.resolve(i.getLocationURI());
                URI pathAbsolute = URI.create(innerDef.getDocumentBaseURI());
                collector.putReferencedResource(pathAbsolute, pathRelativeToRoot);
                ParsedWsdl.parseWsdlRec(innerDef, rootDefUri, CoreUtils.getParentURI((URI)pathRelativeToRoot), collector, loadSchemas);
            }
        }
        URI uriOfCurrentDefinition = URI.create(def.getDocumentBaseURI());
        Map services = def.getServices();
        for (Service service : services.values()) {
            collector.putService(service, uriOfCurrentDefinition);
        }
        Map portTypes = def.getPortTypes();
        for (PortType pt : portTypes.values()) {
            collector.putPortType(pt, uriOfCurrentDefinition);
        }
        Types types = def.getTypes();
        if (types == null) {
            return;
        }
        if (loadSchemas) {
            for (ExtensibilityElement e : ParsedWsdl.extensibilityElementsOf((ElementExtensible)types)) {
                if (!(e instanceof Schema)) continue;
                ParsedWsdl.parseSchemasRec((Schema)e, rootDefUri, relPath, collector);
            }
        }
    }

    protected static void parseSchemasRec(Schema s, URI rootUri, URI relPath, ParsedWsdl collector) throws UnsupportedEncodingException {
        if (s == null) {
            return;
        }
        Map imports = s.getImports();
        List includes = s.getIncludes();
        if (includes.isEmpty() && imports.isEmpty()) {
            return;
        }
        ArrayList references = new ArrayList();
        for (List is : imports.values()) {
            references.addAll(is);
        }
        references.addAll(includes);
        if (references.isEmpty()) {
            return;
        }
        for (SchemaReference ref : references) {
            String schemaLocationURI = ref.getSchemaLocationURI();
            URI pathRelativeToRoot = null;
            boolean exists = false;
            if (StringUtils.isBlank((CharSequence)schemaLocationURI)) {
                pathRelativeToRoot = relPath;
            } else {
                URI pathAbsolute = URI.create(schemaLocationURI);
                if (StringUtils.isNotBlank((CharSequence)pathAbsolute.getRawFragment())) continue;
                if (pathAbsolute.isAbsolute()) {
                    pathRelativeToRoot = pathAbsolute;
                } else {
                    pathAbsolute = rootUri.resolve(relPath).resolve(pathAbsolute).normalize();
                    pathRelativeToRoot = CoreUtils.relativizeURI((URI)rootUri, (URI)pathAbsolute);
                }
                boolean bl = exists = collector.putReferencedResource(pathAbsolute, pathRelativeToRoot) != null;
            }
            if (exists) continue;
            ParsedWsdl.parseSchemasRec(ref.getReferencedSchema(), rootUri, CoreUtils.getParentURI((URI)pathRelativeToRoot), collector);
        }
    }

    public static class WebServiceNames {
        private final String m_wsBaseName;
        private final String m_wsNameFromWsdl;

        protected WebServiceNames(String wsNameLocalPart) {
            this.m_wsNameFromWsdl = wsNameLocalPart;
            this.m_wsBaseName = WebServiceNames.getBaseName(this.m_wsNameFromWsdl);
        }

        public String getWebServiceNameFromWsdl() {
            return this.m_wsNameFromWsdl;
        }

        public String getWebServiceClassName() {
            return String.valueOf(this.m_wsBaseName) + "Service";
        }

        public String getPortTypeClassName(String portTypeNameFromWsdl) {
            return String.valueOf('I') + WebServiceNames.getBaseName(portTypeNameFromWsdl) + "PortType";
        }

        public String getEntryPointClassName(String portTypeNameFromWsdl) {
            return String.valueOf(WebServiceNames.getBaseName(portTypeNameFromWsdl)) + "WebServiceEntryPoint";
        }

        public String getWebServiceClientClassName(String portTypeNameFromWsdl) {
            return String.valueOf(WebServiceNames.getBaseName(portTypeNameFromWsdl)) + "WebServiceClient";
        }

        public String getWebServiceProviderImplClassName(String portTypeNameFromWsdl) {
            return String.valueOf(WebServiceNames.getBaseName(portTypeNameFromWsdl)) + "WebService";
        }

        public String getEntryPointDefinitionClassName(String portTypeNameFromWsdl) {
            return String.valueOf('I') + WebServiceNames.getBaseName(portTypeNameFromWsdl) + "WebServiceEntryPointDefinition";
        }

        protected static String getBaseName(String wsNameFromWsdl) {
            return WebServiceNames.wsdlNameToJavaName(JaxWsUtils.removeCommonSuffixes(wsNameFromWsdl));
        }

        protected static String wsdlNameToJavaName(String name) {
            String[] parts = name.split("[^a-zA-Z0-9]");
            StringBuilder nameBuilder = new StringBuilder(name.length());
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                nameBuilder.append(CoreUtils.ensureStartWithUpperCase((String)part));
                ++n2;
            }
            return nameBuilder.toString();
        }
    }
}

