/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.dto;

import java.util.List;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.AbstractDtoTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.form.FormDataTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table.TableFieldBeanFormDataSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.dto.table.TableRowDataTypeSourceBuilder;
import org.eclipse.scout.sdk.core.s.util.DtoUtils;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;

public class CompositeFormDataTypeSourceBuilder
extends FormDataTypeSourceBuilder {
    public CompositeFormDataTypeSourceBuilder(IType modelType, FormDataAnnotationDescriptor formDataAnnotation, String targetPackageName, String typeName, IJavaEnvironment env) {
        super(modelType, formDataAnnotation, targetPackageName, typeName, env);
    }

    @Override
    protected void createContent() {
        super.createContent();
        this.createCompositeFieldFormData(this.getModelType());
    }

    private void createCompositeFieldFormData(IType compositeType) {
        List innerTypes = compositeType.innerTypes().withInstanceOf("org.eclipse.scout.rt.client.ui.form.fields.IFormField").list();
        for (IType formField : innerTypes) {
            boolean fieldExtendsTemplateField = false;
            if (!Flags.isPublic((int)formField.flags())) continue;
            FormDataAnnotationDescriptor fieldAnnotation = DtoUtils.getFormDataAnnotationDescriptor(formField);
            if (FormDataAnnotationDescriptor.isCreate(fieldAnnotation)) {
                IType formDataType = fieldAnnotation.getFormDataType();
                String formDataTypeName = null;
                formDataTypeName = formDataType == null ? DtoUtils.removeFieldSuffix(formField.elementName()) : formDataType.elementName();
                AbstractDtoTypeSourceBuilder fieldSourceBuilder = null;
                if (fieldAnnotation.getSuperType().isInstanceOf("org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData")) {
                    fieldSourceBuilder = new TableFieldBeanFormDataSourceBuilder(formField, fieldAnnotation, this.getTargetPackage(), formDataTypeName, this.getJavaEnvironment());
                } else if (formField.isInstanceOf("org.eclipse.scout.rt.client.ui.form.fields.ICompositeField") && !formField.isInstanceOf("org.eclipse.scout.rt.client.ui.form.fields.IValueField")) {
                    fieldExtendsTemplateField = true;
                    fieldSourceBuilder = new CompositeFormDataTypeSourceBuilder(formField, fieldAnnotation, this.getTargetPackage(), formDataTypeName, this.getJavaEnvironment());
                } else {
                    fieldSourceBuilder = new FormDataTypeSourceBuilder(formField, fieldAnnotation, this.getTargetPackage(), formDataTypeName, this.getJavaEnvironment());
                    for (IMethodSourceBuilder msb : this.getMethods()) {
                        String methodName = String.valueOf(CoreUtils.getGetterMethodPrefix((String)msb.getReturnTypeSignature())) + formDataTypeName;
                        if (!methodName.equals(msb.getElementName())) continue;
                        fieldSourceBuilder.setComment(CommentSourceBuilderFactory.createCustomCommentBuilder((String)("TODO [everyone] Duplicate names '" + formDataTypeName + "'. Rename property or form field.")));
                        break;
                    }
                }
                fieldSourceBuilder.setFlags(fieldSourceBuilder.getFlags() | 8);
                this.addSortedType(SortedMemberKeyFactory.createTypeFormDataPropertyKey((ITypeSourceBuilder)fieldSourceBuilder), (ITypeSourceBuilder)fieldSourceBuilder);
                DtoUtils.addFormDataAdditionalInterfaces(fieldAnnotation, (ITypeSourceBuilder)fieldSourceBuilder, this.getJavaEnvironment());
                String methodName = CoreUtils.ensureStartWithUpperCase((String)formDataTypeName);
                MethodSourceBuilder getterBuilder = new MethodSourceBuilder("get" + methodName);
                getterBuilder.setFlags(1);
                getterBuilder.setReturnTypeSignature(Signature.createTypeSignature((String)formDataTypeName, (boolean)false));
                getterBuilder.setBody((ISourceBuilder)new RawSourceBuilder("return getFieldByClass(" + formDataTypeName + SuffixConstants.SUFFIX_class + ");"));
                this.addSortedMethod(SortedMemberKeyFactory.createMethodPropertyKey((IMethodSourceBuilder)getterBuilder), (IMethodSourceBuilder)getterBuilder);
            } else if (FormDataAnnotationDescriptor.isIgnore(fieldAnnotation)) continue;
            if (!formField.isInstanceOf("org.eclipse.scout.rt.client.ui.form.fields.ICompositeField") || fieldExtendsTemplateField) continue;
            this.createCompositeFieldFormData(formField);
        }
        for (IType formFieldExtension : compositeType.innerTypes().withInstanceOf("org.eclipse.scout.rt.client.extension.ui.form.fields.ICompositeFieldExtension").list()) {
            this.createCompositeFieldFormData(formFieldExtension);
        }
        for (IType tableExtension : compositeType.innerTypes().withRecursiveInnerTypes(true).withInstanceOf("org.eclipse.scout.rt.client.extension.ui.basic.table.ITableExtension").list()) {
            String rowDataName = DtoUtils.getRowDataName(tableExtension.elementName());
            TableRowDataTypeSourceBuilder rowDataSourceBuilder = new TableRowDataTypeSourceBuilder(rowDataName, tableExtension, tableExtension, this.getJavaEnvironment());
            this.addSortedType(SortedMemberKeyFactory.createTypeFormDataPropertyKey((ITypeSourceBuilder)rowDataSourceBuilder), (ITypeSourceBuilder)rowDataSourceBuilder);
            DtoUtils.addDtoExtendsAnnotation((ITypeSourceBuilder)rowDataSourceBuilder, (IAnnotatable)tableExtension);
        }
    }
}

