/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.jaxws;

import java.util.ArrayList;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.sourcebuilder.ExpressionSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class EntryPointDefinitionSourceBuilder
extends AbstractEntitySourceBuilder {
    private String m_portTypeFqn;
    private String m_serviceName;
    private String m_portName;
    private String m_entryPointPackage;
    private String m_entryPointName;

    public EntryPointDefinitionSourceBuilder(String entityName, String packageName, IJavaEnvironment env) {
        super(entityName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder typeBuilder = new TypeSourceBuilder(this.getEntityName());
        typeBuilder.setFlags(513);
        this.addType((ITypeSourceBuilder)typeBuilder);
        AnnotationSourceBuilder webServiceEntryPointBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.server.jaxws.provider.annotation.WebServiceEntryPoint");
        webServiceEntryPointBuilder.putElement("endpointInterface", new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(validator.useName(EntryPointDefinitionSourceBuilder.this.getPortTypeFqn())).append(".class");
            }
        });
        webServiceEntryPointBuilder.putElement("entryPointPackage", CoreUtils.toStringLiteral((String)this.getEntryPointPackage()));
        webServiceEntryPointBuilder.putElement("entryPointName", CoreUtils.toStringLiteral((String)this.getEntryPointName()));
        webServiceEntryPointBuilder.putElement("serviceName", CoreUtils.toStringLiteral((String)this.getServiceName()));
        webServiceEntryPointBuilder.putElement("portName", CoreUtils.toStringLiteral((String)this.getPortName()));
        ArrayList<IAnnotationSourceBuilder> handlers = new ArrayList<IAnnotationSourceBuilder>(2);
        handlers.add(this.createHandlerBuilder("org.eclipse.scout.rt.server.jaxws.handler.WsProviderCorrelationIdHandler"));
        handlers.add(this.createHandlerBuilder("org.eclipse.scout.rt.server.jaxws.handler.LogHandler"));
        webServiceEntryPointBuilder.putElement("handlerChain", ExpressionSourceBuilderFactory.createArray(handlers, (boolean)true));
        webServiceEntryPointBuilder.putElement("authentication", (ISourceBuilder)this.createAuthenticationBuilder());
        typeBuilder.addAnnotation((IAnnotationSourceBuilder)webServiceEntryPointBuilder);
    }

    protected IAnnotationSourceBuilder createAuthenticationBuilder() {
        AnnotationSourceBuilder authentication = new AnnotationSourceBuilder("org.eclipse.scout.rt.server.jaxws.provider.annotation.Authentication");
        authentication.putElement("method", (ISourceBuilder)this.createClazzBuilder("org.eclipse.scout.rt.server.jaxws.provider.auth.method.BasicAuthenticationMethod"));
        authentication.putElement("verifier", (ISourceBuilder)this.createClazzBuilder("org.eclipse.scout.rt.platform.security.ConfigFileCredentialVerifier"));
        return authentication;
    }

    protected IAnnotationSourceBuilder createClazzBuilder(final String clazzFqn) {
        AnnotationSourceBuilder clazz = new AnnotationSourceBuilder("org.eclipse.scout.rt.server.jaxws.provider.annotation.Clazz");
        clazz.putElement("value", new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(validator.useName(clazzFqn)).append(".class");
            }
        });
        return clazz;
    }

    protected IAnnotationSourceBuilder createHandlerBuilder(String handlerFqn) {
        AnnotationSourceBuilder handlerBuilder = new AnnotationSourceBuilder("org.eclipse.scout.rt.server.jaxws.provider.annotation.Handler");
        handlerBuilder.putElement("value", (ISourceBuilder)this.createClazzBuilder(handlerFqn));
        return handlerBuilder;
    }

    public String getPortTypeFqn() {
        return this.m_portTypeFqn;
    }

    public void setPortTypeFqn(String portTypeFqn) {
        this.m_portTypeFqn = portTypeFqn;
    }

    public String getEntryPointPackage() {
        return this.m_entryPointPackage;
    }

    public void setEntryPointPackage(String entryPointPackage) {
        this.m_entryPointPackage = entryPointPackage;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public String getPortName() {
        return this.m_portName;
    }

    public void setPortName(String portName) {
        this.m_portName = portName;
    }

    public String getEntryPointName() {
        return this.m_entryPointName;
    }

    public void setEntryPointName(String entryPointName) {
        this.m_entryPointName = entryPointName;
    }
}

