/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.jaxws;

import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodBodySourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkLog;

public class WebServiceClientSourceBuilder
extends AbstractEntitySourceBuilder {
    private String m_portTypeSignature;
    private String m_serviceSignature;

    public WebServiceClientSourceBuilder(String elementName, String packageName, IJavaEnvironment env) {
        super(elementName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder clientBuilder = new TypeSourceBuilder(this.getEntityName());
        clientBuilder.setFlags(1);
        StringBuilder superTypeFqnBuilder = new StringBuilder("org.eclipse.scout.rt.server.jaxws.consumer.AbstractWebServiceClient");
        superTypeFqnBuilder.append('<').append(SignatureUtils.toFullyQualifiedName((String)this.getServiceSignature())).append(", ").append(SignatureUtils.toFullyQualifiedName((String)this.getPortTypeSignature())).append('>');
        clientBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeFqnBuilder.toString()));
        clientBuilder.addInterfaceSignature(this.getPortTypeSignature());
        this.addType((ITypeSourceBuilder)clientBuilder);
        ITypeSourceBuilder urlPropertyType = this.createUrlPropertyType();
        clientBuilder.addType(urlPropertyType);
        clientBuilder.addMethod(this.createExecInstallHandlers((ITypeSourceBuilder)clientBuilder));
        clientBuilder.addMethod(this.createGetConfiguredEndpointUrlProperty((ITypeSourceBuilder)clientBuilder, urlPropertyType));
        if (this.getJavaEnvironment().findType(SignatureUtils.toFullyQualifiedName((String)this.getPortTypeSignature())) == null || this.getJavaEnvironment().findType(SignatureUtils.toFullyQualifiedName((String)this.getServiceSignature())) == null) {
            SdkLog.warning((String)"Web Service client could not be filled with all methods because the port type or web service stub could not be found.", (Object[])new Object[0]);
            return;
        }
        this.addUnimplementedMethods((ITypeSourceBuilder)clientBuilder);
    }

    protected void addUnimplementedMethods(ITypeSourceBuilder builder) {
        List unimplementedMethods = MethodSourceBuilderFactory.createUnimplementedMethods((ITypeSourceBuilder)builder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment());
        for (IMethodSourceBuilder unimplemented : unimplementedMethods) {
            StringBuilder bodyBuilder = new StringBuilder();
            if (!"V".equals(unimplemented.getReturnTypeSignature())) {
                bodyBuilder.append("return ");
            }
            bodyBuilder.append("newInvocationContext().getPort().").append(unimplemented.getElementName()).append('(');
            Iterator parameters = unimplemented.getParameters().iterator();
            if (parameters.hasNext()) {
                IMethodParameterSourceBuilder parameterSourceBuilder = (IMethodParameterSourceBuilder)parameters.next();
                bodyBuilder.append(parameterSourceBuilder.getElementName());
                while (parameters.hasNext()) {
                    parameterSourceBuilder = (IMethodParameterSourceBuilder)parameters.next();
                    bodyBuilder.append(", ");
                    bodyBuilder.append(parameterSourceBuilder.getElementName());
                }
            }
            bodyBuilder.append(");");
            unimplemented.setBody((ISourceBuilder)new RawSourceBuilder(bodyBuilder.toString()));
            builder.addMethod(unimplemented);
        }
    }

    protected String getBaseName() {
        String name = this.getEntityName();
        if (name.endsWith("WebServiceClient")) {
            name = name.substring(0, name.length() - "WebServiceClient".length());
        }
        return name;
    }

    public String getUrlPropertyName() {
        return "jaxws." + this.getBaseName().toLowerCase() + ".url";
    }

    protected ITypeSourceBuilder createUrlPropertyType() {
        TypeSourceBuilder urlProperty = new TypeSourceBuilder(String.valueOf(this.getBaseName()) + "WebServiceUrlProperty");
        urlProperty.setFlags(9);
        urlProperty.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty"));
        IMethodSourceBuilder getKey = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)urlProperty, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getKey");
        getKey.setBody((ISourceBuilder)new RawSourceBuilder("return " + CoreUtils.toStringLiteral((String)this.getUrlPropertyName()) + ';'));
        urlProperty.addMethod(getKey);
        return urlProperty;
    }

    protected IMethodSourceBuilder createGetConfiguredEndpointUrlProperty(ITypeSourceBuilder wsClientType, ITypeSourceBuilder propertyType) {
        IMethodSourceBuilder getConfiguredEndpointUrlProperty = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)wsClientType, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"getConfiguredEndpointUrlProperty");
        getConfiguredEndpointUrlProperty.setBody(MethodBodySourceBuilderFactory.createReturnClassReference((String)Signature.createTypeSignature((String)propertyType.getFullyQualifiedName())));
        getConfiguredEndpointUrlProperty.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigProperty");
        return getConfiguredEndpointUrlProperty;
    }

    protected IMethodSourceBuilder createExecInstallHandlers(ITypeSourceBuilder wsClientType) {
        IMethodSourceBuilder execInstallHandlers = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)wsClientType, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"execInstallHandlers");
        final String chainVarName = ((IMethodParameterSourceBuilder)execInstallHandlers.getParameters().get(0)).getElementName();
        execInstallHandlers.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                source.append(chainVarName).append(".add(").append(validator.useName("org.eclipse.scout.rt.platform.BEANS")).append(".get(").append(validator.useName("org.eclipse.scout.rt.server.jaxws.handler.LogHandler")).append(".class").append("));").append(lineDelimiter);
                source.append(chainVarName).append(".add(").append(validator.useName("org.eclipse.scout.rt.platform.BEANS")).append(".get(").append(validator.useName("org.eclipse.scout.rt.server.jaxws.handler.WsConsumerCorrelationIdHandler")).append(".class").append("));");
            }
        });
        execInstallHandlers.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigOperation");
        return execInstallHandlers;
    }

    public String getPortTypeSignature() {
        return this.m_portTypeSignature;
    }

    public void setPortTypeSignature(String portTypeSignature) {
        this.m_portTypeSignature = portTypeSignature;
    }

    public String getServiceSignature() {
        return this.m_serviceSignature;
    }

    public void setServiceSignature(String serviceSignature) {
        this.m_serviceSignature = serviceSignature;
    }
}

