/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MavenBuild {
    private File m_workingDirectory;
    private final Set<String> m_goals;
    private final Map<String, String> m_properties = new LinkedHashMap<String, String>();
    private final Set<String> m_options;

    public MavenBuild() {
        this.m_goals = new LinkedHashSet<String>();
        this.m_options = new LinkedHashSet<String>();
    }

    public File getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    public MavenBuild withWorkingDirectory(File workingDirectory) {
        this.m_workingDirectory = (File)Validate.notNull((Object)workingDirectory);
        return this;
    }

    public Set<String> getOptions() {
        return Collections.unmodifiableSet(this.m_options);
    }

    public boolean hasOption(String option) {
        return this.m_options.contains(option);
    }

    public boolean hasOption(char option) {
        return this.hasOption(Character.toString(option));
    }

    public MavenBuild withOption(char option) {
        return this.withOption(Character.toString(option));
    }

    public MavenBuild withOption(String option) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)option));
        this.m_options.add(option);
        return this;
    }

    public Set<String> getGoals() {
        return Collections.unmodifiableSet(this.m_goals);
    }

    public MavenBuild withGoal(String goals) {
        this.m_goals.add(goals);
        return this;
    }

    public List<String> getPropertiesAsList() {
        return MavenBuild.getMapAsList(this.getProperties());
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.m_properties);
    }

    public MavenBuild withProperty(char property) {
        return this.withProperty(Character.toString(property));
    }

    public MavenBuild withProperty(String noValueProperty) {
        return this.withProperty(noValueProperty, null);
    }

    public MavenBuild withProperty(String key, String value) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key));
        this.m_properties.put(key.trim(), value);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_goals == null ? 0 : this.m_goals.hashCode());
        result = 31 * result + (this.m_options == null ? 0 : this.m_options.hashCode());
        result = 31 * result + (this.m_properties == null ? 0 : this.m_properties.hashCode());
        result = 31 * result + (this.m_workingDirectory == null ? 0 : this.m_workingDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenBuild other = (MavenBuild)obj;
        if (this.m_goals == null ? other.m_goals != null : !this.m_goals.equals(other.m_goals)) {
            return false;
        }
        if (this.m_options == null ? other.m_options != null : !this.m_options.equals(other.m_options)) {
            return false;
        }
        if (this.m_properties == null ? other.m_properties != null : !this.m_properties.equals(other.m_properties)) {
            return false;
        }
        return !(this.m_workingDirectory == null ? other.m_workingDirectory != null : !this.m_workingDirectory.equals(other.m_workingDirectory));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Maven build in dir '").append(this.getWorkingDirectory()).append("': ");
        for (String goal : this.getGoals()) {
            builder.append(goal).append(' ');
        }
        for (String option : this.getOptions()) {
            builder.append('-').append(option).append(' ');
        }
        for (String prop : this.getPropertiesAsList()) {
            builder.append("-D").append(prop).append(' ');
        }
        return builder.toString();
    }

    public static List<String> getMapAsList(Map<String, String> properties) {
        ArrayList<String> props = new ArrayList<String>(properties.size());
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            StringBuilder propBuilder = new StringBuilder(prop.getKey());
            if (prop.getValue() != null) {
                propBuilder.append('=');
                propBuilder.append(prop.getValue());
            }
            props.add(propBuilder.toString());
        }
        return props;
    }
}

