/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.swt;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.swt.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class CompositeUpdater {
    private LayoutRunnable layoutRunnable = new LayoutRunnable();
    private PrivateInterface privateInterface = new PrivateInterface();
    private Composite theComposite;
    private IObservableList model;

    protected void requestLayout(Control control) {
        this.layoutRunnable.add(control);
    }

    public CompositeUpdater(Composite toUpdate, IObservableList model) {
        this.theComposite = toUpdate;
        this.model = model;
        model.addListChangeListener((IListChangeListener)this.privateInterface);
        this.theComposite.addDisposeListener((DisposeListener)this.privateInterface);
        ObservableTracker.setIgnore((boolean)true);
        try {
            int index = 0;
            for (Object element : this.model) {
                this.createChild(element, index++);
            }
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    protected void disposeWidget(int position) {
        this.theComposite.getChildren()[position].dispose();
    }

    public void dispose() {
        this.theComposite.removeDisposeListener((DisposeListener)this.privateInterface);
        this.model.removeListChangeListener((IListChangeListener)this.privateInterface);
    }

    protected abstract Widget createWidget(int var1);

    protected abstract void updateWidget(Widget var1, Object var2);

    void createChild(Object element, int index) {
        Widget newChild = this.createWidget(index);
        UpdateRunnable updateRunnable = new UpdateRunnable(newChild, element);
        newChild.setData((Object)updateRunnable);
        updateRunnable.updateIfNecessary();
    }

    private class LayoutRunnable
    implements Runnable {
        private boolean posted = false;
        private Set controlsToLayout = new HashSet();

        private LayoutRunnable() {
        }

        void add(Control toLayout) {
            this.controlsToLayout.add(toLayout);
            if (!this.posted) {
                this.posted = true;
                CompositeUpdater.this.theComposite.getDisplay().asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.posted = false;
            CompositeUpdater.this.theComposite.getShell().layout(this.controlsToLayout.toArray(new Control[this.controlsToLayout.size()]));
            this.controlsToLayout.clear();
        }
    }

    private class PrivateInterface
    implements DisposeListener,
    IListChangeListener {
        private PrivateInterface() {
        }

        public void widgetDisposed(DisposeEvent e) {
            CompositeUpdater.this.dispose();
        }

        public void handleListChange(ListChangeEvent event) {
            ListDiffEntry[] diffs;
            ListDiffEntry[] listDiffEntryArray = diffs = event.diff.getDifferences();
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry listDiffEntry = listDiffEntryArray[n2];
                if (listDiffEntry.isAddition()) {
                    CompositeUpdater.this.createChild(listDiffEntry.getElement(), listDiffEntry.getPosition());
                } else {
                    CompositeUpdater.this.disposeWidget(listDiffEntry.getPosition());
                }
                ++n2;
            }
            CompositeUpdater.this.theComposite.layout();
        }
    }

    private class UpdateRunnable
    implements Runnable,
    IChangeListener {
        private Widget widget;
        Object element;
        private boolean dirty = true;
        private IObservable[] dependencies = new IObservable[0];

        UpdateRunnable(Widget widget, Object element) {
            this.widget = widget;
            this.element = element;
        }

        @Override
        public void run() {
            if (CompositeUpdater.this.theComposite != null && !CompositeUpdater.this.theComposite.isDisposed() && this.widget != null && !this.widget.isDisposed()) {
                this.updateIfNecessary();
            }
        }

        private void updateIfNecessary() {
            if (this.dirty) {
                this.dependencies = ObservableTracker.runAndMonitor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CompositeUpdater.this.updateWidget(UpdateRunnable.this.widget, UpdateRunnable.this.element);
                    }
                }, (IChangeListener)this, null);
                this.dirty = false;
            }
        }

        public void handleChange(ChangeEvent event) {
            this.makeDirty();
        }

        protected final void makeDirty() {
            if (!this.dirty) {
                this.dirty = true;
                this.stopListening();
                if (!CompositeUpdater.this.theComposite.isDisposed()) {
                    SWTUtil.runOnce(CompositeUpdater.this.theComposite.getDisplay(), this);
                }
            }
        }

        private void stopListening() {
            IObservable[] iObservableArray = this.dependencies;
            int n = this.dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable observable = iObservableArray[n2];
                observable.removeChangeListener((IChangeListener)this);
                ++n2;
            }
        }
    }
}

