/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.buildpath.P2Utils;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class BuildPathSupport {
    public static final JUnitPluginDescription JUNIT3_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[3.8.2,3.9)"), "junit.jar", "junit.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit3.javadoclocation");
    public static final JUnitPluginDescription JUNIT4_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[4.7.0,5.0.0)"), "junit.jar", "junit.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.javadoclocation");
    private static final JUnitPluginDescription HAMCREST_CORE_PLUGIN = new JUnitPluginDescription("org.hamcrest.core", new VersionRange("[1.1.0,2.0.0)"), null, "org.hamcrest.core_1.*.jar", "org.hamcrest.core.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_API_PLUGIN = new JUnitPluginDescription("org.junit.jupiter.api", new VersionRange("[5.0.0,6.0.0)"), "org.junit.jupiter.api.jar", "", "org.junit.jupiter.api.source", "", "org.eclipse.jdt.junit.junit5.jupiter.api.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_ENGINE_PLUGIN = new JUnitPluginDescription("org.junit.jupiter.engine", new VersionRange("[5.0.0,6.0.0)"), "org.junit.jupiter.engine.jar", "", "org.junit.jupiter.engine.source", "", "org.eclipse.jdt.junit.junit5.jupiter.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_MIGRATIONSUPPORT_PLUGIN = new JUnitPluginDescription("org.junit.jupiter.migrationsupport", new VersionRange("[5.0.0,6.0.0)"), "org.junit.jupiter.migrationsupport.jar", "", "org.junit.jupiter.migrationsupport.source", "", "org.eclipse.jdt.junit.junit5.jupiter.migrationsupport.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_PARAMS_PLUGIN = new JUnitPluginDescription("org.junit.jupiter.params", new VersionRange("[5.0.0,6.0.0)"), "org.junit.jupiter.params.jar", "", "org.junit.jupiter.params.source", "", "org.eclipse.jdt.junit.junit5.jupiter.params.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_COMMONS_PLUGIN = new JUnitPluginDescription("org.junit.platform.commons", new VersionRange("[1.0.0,2.0.0)"), "org.junit.platform.commons.jar", "", "org.junit.platform.commons.source", "", "org.eclipse.jdt.junit.junit5.platform.commons.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_ENGINE_PLUGIN = new JUnitPluginDescription("org.junit.platform.engine", new VersionRange("[1.0.0,2.0.0)"), "org.junit.platform.engine.jar", "", "org.junit.platform.engine.source", "", "org.eclipse.jdt.junit.junit5.platform.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_LAUNCHER_PLUGIN = new JUnitPluginDescription("org.junit.platform.launcher", new VersionRange("[1.0.0,2.0.0)"), "org.junit.platform.launcher.jar", "", "org.junit.platform.launcher.source", "", "org.eclipse.jdt.junit.junit5.platform.launcher.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_RUNNER_PLUGIN = new JUnitPluginDescription("org.junit.platform.runner", new VersionRange("[1.0.0,2.0.0)"), "org.junit.platform.runner.jar", "", "org.junit.platform.runner.source", "", "org.eclipse.jdt.junit.junit5.platform.runner.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_SUITE_API_PLUGIN = new JUnitPluginDescription("org.junit.platform.suite.api", new VersionRange("[1.0.0,2.0.0)"), "org.junit.platform.suite.api.jar", "", "org.junit.platform.suite.api.source", "", "org.eclipse.jdt.junit.junit5.platform.suite.api.javadoclocation");
    public static final JUnitPluginDescription JUNIT_VINTAGE_ENGINE_PLUGIN = new JUnitPluginDescription("org.junit.vintage.engine", new VersionRange("[4.12.0,5.0.0)"), "org.junit.vintage.engine.jar", "", "org.junit.vintage.engine.source", "", "org.eclipse.jdt.junit.junit5.vintage.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_OPENTEST4J_PLUGIN = new JUnitPluginDescription("org.opentest4j", new VersionRange("[1.0.0,2.0.0)"), "org.opentest4j.jar", "", "org.opentest4j.source", "", "org.eclipse.jdt.junit.junit5.opentest4j.javadoclocation");
    public static final JUnitPluginDescription JUNIT_APIGUARDIAN_PLUGIN = new JUnitPluginDescription("org.apiguardian", new VersionRange("[1.0.0,2.0.0)"), "org.apiguardian.jar", "", "org.apiguardian.source", "", "org.eclipse.jdt.junit.junit5.apiguardian.javadoclocation");
    public static final JUnitPluginDescription JUNIT4_AS_3_PLUGIN = new JUnitPluginDescription(JUnitPluginDescription.access$0(JUNIT4_PLUGIN), JUnitPluginDescription.access$1(JUNIT4_PLUGIN), JUnitPluginDescription.access$2(JUNIT4_PLUGIN), JUnitPluginDescription.access$3(JUNIT4_PLUGIN), JUnitPluginDescription.access$4(JUNIT4_PLUGIN), JUnitPluginDescription.access$5(JUNIT4_PLUGIN), JUnitPluginDescription.access$6(JUNIT3_PLUGIN)){

        @Override
        public IAccessRule[] getAccessRules() {
            return new IAccessRule[]{JavaCore.newAccessRule((IPath)new Path("junit/"), (int)0), JavaCore.newAccessRule((IPath)new Path("**/*"), (int)1)};
        }
    };

    public static IClasspathEntry getJUnit3ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT3_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit4ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT4_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit5ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT5_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit3LibraryEntry() {
        return JUNIT3_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit4LibraryEntry() {
        return JUNIT4_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit4as3LibraryEntry() {
        return JUNIT4_AS_3_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getHamcrestCoreLibraryEntry() {
        return HAMCREST_CORE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterApiLibraryEntry() {
        return JUNIT_JUPITER_API_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterEngineLibraryEntry() {
        return JUNIT_JUPITER_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterMigrationSupportLibraryEntry() {
        return JUNIT_JUPITER_MIGRATIONSUPPORT_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterParamsLibraryEntry() {
        return JUNIT_JUPITER_PARAMS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformCommonsLibraryEntry() {
        return JUNIT_PLATFORM_COMMONS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformEngineLibraryEntry() {
        return JUNIT_PLATFORM_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformLauncherLibraryEntry() {
        return JUNIT_PLATFORM_LAUNCHER_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformRunnerLibraryEntry() {
        return JUNIT_PLATFORM_RUNNER_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformSuiteApiLibraryEntry() {
        return JUNIT_PLATFORM_SUITE_API_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitVintageEngineLibraryEntry() {
        return JUNIT_VINTAGE_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitOpentest4jLibraryEntry() {
        return JUNIT_OPENTEST4J_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitApiGuardianLibraryEntry() {
        return JUNIT_APIGUARDIAN_PLUGIN.getLibraryEntry();
    }

    public static class JUnitPluginDescription {
        private final String bundleId;
        private final VersionRange versionRange;
        private final String bundleRoot;
        private final String binaryImportedRoot;
        private final String sourceBundleId;
        private final String repositorySource;
        private final String javadocPreferenceKey;
        private String resolvedVersion = null;

        public JUnitPluginDescription(String bundleId, VersionRange versionRange, String bundleRoot, String binaryImportedRoot, String sourceBundleId, String repositorySource, String javadocPreferenceKey) {
            this.bundleId = bundleId;
            this.versionRange = versionRange;
            this.bundleRoot = bundleRoot;
            this.binaryImportedRoot = binaryImportedRoot;
            this.sourceBundleId = sourceBundleId;
            this.repositorySource = repositorySource;
            this.javadocPreferenceKey = javadocPreferenceKey;
        }

        public IPath getBundleLocation() {
            return this.getBundleLocation(this.bundleId, this.versionRange);
        }

        public IPath getSourceBundleLocation() {
            return this.getSourceLocation(this.getBundleLocation());
        }

        private IPath getBundleLocation(String aBundleId, VersionRange aVersionRange) {
            return this.getBundleLocation(aBundleId, aVersionRange, false);
        }

        private IPath getBundleLocation(String aBundleId, VersionRange aVersionRange, boolean isSourceBundle) {
            BundleInfo bundleInfo = P2Utils.findBundle(aBundleId, aVersionRange, isSourceBundle);
            if (bundleInfo != null) {
                this.resolvedVersion = bundleInfo.getVersion();
                return P2Utils.getBundleLocationPath(bundleInfo);
            }
            Bundle[] bundles = Platform.getBundles((String)aBundleId, (String)aVersionRange.toString());
            Bundle bestMatch = null;
            if (bundles != null) {
                int i = 0;
                while (i < bundles.length) {
                    Bundle bundle = bundles[i];
                    if (bestMatch == null || bundle.getState() > bestMatch.getState()) {
                        bestMatch = bundle;
                    }
                    ++i;
                }
            }
            if (bestMatch != null) {
                try {
                    this.resolvedVersion = bestMatch.getVersion().toString();
                    URL rootUrl = bestMatch.getEntry("/");
                    URL fileRootUrl = FileLocator.toFileURL((URL)rootUrl);
                    return new Path(fileRootUrl.getPath());
                }
                catch (IOException ex) {
                    JUnitCorePlugin.log(ex);
                }
            }
            return null;
        }

        public IClasspathEntry getLibraryEntry() {
            IPath bundleLocation = this.getBundleLocation(this.bundleId, this.versionRange);
            if (bundleLocation != null) {
                IPath bundleRootLocation = null;
                if (this.bundleRoot != null) {
                    bundleRootLocation = this.getLocationIfExists(bundleLocation, this.bundleRoot);
                }
                if (bundleRootLocation == null && this.binaryImportedRoot != null) {
                    bundleRootLocation = this.getLocationIfExists(bundleLocation, this.binaryImportedRoot);
                }
                if (bundleRootLocation == null) {
                    bundleRootLocation = this.getBundleLocation(this.bundleId, this.versionRange);
                }
                IPath srcLocation = this.getSourceLocation(bundleLocation);
                String javadocLocation = Platform.getPreferencesService().getString("org.eclipse.jdt.junit.core", this.javadocPreferenceKey, "", null);
                IClasspathAttribute[] attributes = javadocLocation.length() == 0 ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation)};
                return JavaCore.newLibraryEntry((IPath)bundleRootLocation, (IPath)srcLocation, null, (IAccessRule[])this.getAccessRules(), (IClasspathAttribute[])attributes, (boolean)false);
            }
            return null;
        }

        public IAccessRule[] getAccessRules() {
            return new IAccessRule[0];
        }

        private IPath getSourceLocation(IPath bundleLocation) {
            IPath srcLocation = null;
            if (this.repositorySource != null) {
                srcLocation = this.getLocationIfExists(bundleLocation, this.repositorySource);
            }
            if (srcLocation == null) {
                if (bundleLocation != null) {
                    Version version = new Version(this.resolvedVersion);
                    srcLocation = this.getBundleLocation(this.sourceBundleId, new VersionRange(version, true, version, true), true);
                }
                if (srcLocation == null) {
                    srcLocation = this.getBundleLocation(this.sourceBundleId, this.versionRange, true);
                }
            }
            return srcLocation;
        }

        private IPath getLocationIfExists(IPath bundleLocationPath, String entryInBundle) {
            File bundleFile;
            Path srcLocation = null;
            if (bundleLocationPath != null && (bundleFile = bundleLocationPath.toFile()).isDirectory()) {
                File[] files;
                File srcFile = null;
                int starIdx = entryInBundle.indexOf(42);
                if (starIdx != -1 && (files = bundleFile.listFiles(new FilenameFilter(entryInBundle, starIdx){
                    private String pre;
                    private String post;
                    {
                        this.pre = string.substring(0, n);
                        this.post = string.substring(n + 1);
                    }

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(this.pre) && name.endsWith(this.post);
                    }
                })).length > 0) {
                    srcFile = files[0];
                }
                if (srcFile == null) {
                    srcFile = new File(bundleFile, entryInBundle);
                }
                if (srcFile.exists()) {
                    srcLocation = new Path(srcFile.getPath());
                    if (srcFile.isDirectory()) {
                        srcLocation = srcLocation.addTrailingSeparator();
                    }
                }
            }
            return srcLocation;
        }

        static /* synthetic */ String access$0(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.bundleId;
        }

        static /* synthetic */ VersionRange access$1(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.versionRange;
        }

        static /* synthetic */ String access$2(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.bundleRoot;
        }

        static /* synthetic */ String access$3(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.binaryImportedRoot;
        }

        static /* synthetic */ String access$4(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.sourceBundleId;
        }

        static /* synthetic */ String access$5(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.repositorySource;
        }

        static /* synthetic */ String access$6(JUnitPluginDescription jUnitPluginDescription) {
            return jUnitPluginDescription.javadocPreferenceKey;
        }
    }
}

