/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class TeamViewerSorter
extends TreePathViewerSorter {
    private CommonViewerSorter sorter;
    private ResourceComparator resourceComparator;

    public TeamViewerSorter(CommonViewerSorter sorter) {
        this.sorter = sorter;
        this.resourceComparator = new ResourceComparator(1);
    }

    public int category(Object element) {
        if (element instanceof ModelProvider) {
            return 2;
        }
        IResource resource = Utils.getResource(element);
        if (resource != null && resource.getType() == 4) {
            return 1;
        }
        return super.category(element);
    }

    public int compare(Viewer viewer, TreePath parentPath, Object e1, Object e2) {
        if (parentPath == null || parentPath.getSegmentCount() == 0) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof ModelProvider && e2 instanceof ModelProvider) {
                ModelProvider mp1 = (ModelProvider)e1;
                ModelProvider mp2 = (ModelProvider)e2;
                if (this.isExtends(mp1, mp2.getDescriptor())) {
                    return 1;
                }
                if (this.isExtends(mp2, mp1.getDescriptor())) {
                    return -1;
                }
                return mp1.getDescriptor().getLabel().compareTo(mp2.getDescriptor().getLabel());
            }
            IResource r1 = Utils.getResource(e1);
            IResource r2 = Utils.getResource(e2);
            if (r1 != null && r2 != null) {
                return this.resourceComparator.compare(viewer, (Object)r1, (Object)r2);
            }
        }
        return this.sorter.compare(viewer, parentPath, e1, e2);
    }

    private boolean isExtends(ModelProvider mp1, IModelProviderDescriptor desc) {
        String id;
        String[] extended = mp1.getDescriptor().getExtendedModels();
        int i = 0;
        while (i < extended.length) {
            id = extended[i];
            if (id.equals(desc.getId())) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < extended.length) {
            id = extended[i];
            IModelProviderDescriptor desc2 = ModelProvider.getModelProviderDescriptor((String)id);
            if (this.isExtends(mp1, desc2)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

