/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.autagent.agent.AutAgent;
import org.eclipse.jubula.autagent.i18n.Messages;
import org.eclipse.jubula.autagent.remote.dialogs.ChooseCheckModeDialogBP;
import org.eclipse.jubula.autagent.remote.dialogs.ObservationConsoleBP;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.IConnectionInitializer;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.AutRegisteredMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.jubula.tools.internal.utils.SysoRedirect;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutStarter {
    private static Logger log = LoggerFactory.getLogger(AutStarter.class);
    private static AutStarter instance = null;
    private Communicator m_communicator;
    private Communicator m_autCommunicator;
    private int m_stopAUTServerTimeout = 10000;
    private AutAgent m_agent;
    private CommunicationHelper m_messenger;
    private Verbosity m_verbosity;

    private AutStarter() {
        AutAgent agent = new AutAgent();
        this.m_messenger = new CommunicationHelper();
        agent.addPropertyChangeListener("auts", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Communicator clientComm = AutStarter.getInstance().getCommunicator();
                if (clientComm == null || clientComm.getConnection() == null) {
                    return;
                }
                try {
                    Object oldValue;
                    Object newValue = evt.getNewValue();
                    if (newValue instanceof AutIdentifier) {
                        clientComm.send((Message)new AutRegisteredMessage((AutIdentifier)newValue, true));
                    }
                    if ((oldValue = evt.getOldValue()) instanceof AutIdentifier) {
                        clientComm.send((Message)new AutRegisteredMessage((AutIdentifier)oldValue, false));
                    }
                }
                catch (CommunicationException ce) {
                    log.error(Messages.RegistationSendingError, (Throwable)ce);
                }
            }
        });
        this.m_agent = agent;
    }

    public boolean watchAUT(Process process, boolean isAgentSet, AutIdentifier autId) throws IllegalArgumentException {
        if (process == null) {
            throw new IllegalArgumentException(Messages.ProcessMustNotBeNull);
        }
        new AUTWatcher(process, isAgentSet, this.m_messenger, autId).start();
        return true;
    }

    public static AutStarter getInstance() {
        if (instance == null) {
            instance = new AutStarter();
        }
        return instance;
    }

    public synchronized Communicator getCommunicator() {
        return this.m_communicator;
    }

    public synchronized void setCommunicator(Communicator communicator) {
        this.m_communicator = communicator;
    }

    public synchronized Communicator getAutCommunicator() {
        return this.m_autCommunicator;
    }

    public synchronized void setAutCommunicator(Communicator communicator) {
        this.m_autCommunicator = communicator;
    }

    public int getStopAUTServerTimeout() {
        return this.m_stopAUTServerTimeout;
    }

    public void setStopAUTServerTimeout(int stopAUTServerTimeout) {
        this.m_stopAUTServerTimeout = stopAUTServerTimeout < 0 ? 0 : stopAUTServerTimeout;
    }

    public void start(int port, boolean killDuplicateAuts, Verbosity verbosity, boolean isBlocking) throws UnknownHostException, IOException, JBVersionException {
        this.m_verbosity = verbosity;
        String infoMessage = I18n.getString((String)"AUTAgent.StartErrorText");
        Thread clientSocketThread = null;
        try {
            this.getAgent().setKillDuplicateAuts(killDuplicateAuts);
            infoMessage = I18n.getString((String)"AUTAgent.StartCommErrorText", (Object[])new Object[]{"" + port});
            clientSocketThread = this.initClientConnectionSocket(port);
            this.initAutConnectionSocket();
            infoMessage = this.m_verbosity.compareTo(Verbosity.VERBOSE) >= 0 ? String.valueOf(I18n.getString((String)"AUTAgent.StartSuccessText")) + this.getCommunicator().getLocalPort() + "." : "";
        }
        finally {
            if (infoMessage.length() > 0) {
                this.showUserInfo(infoMessage);
            }
            if (isBlocking && clientSocketThread != null) {
                try {
                    clientSocketThread.join();
                }
                catch (InterruptedException e) {
                    log.warn(Messages.InterruptedThread, (Throwable)e);
                }
            }
        }
    }

    private Thread initClientConnectionSocket(int port) throws IOException, JBVersionException {
        HashMap<String, IConnectionInitializer> clientTypeToInitializer = new HashMap<String, IConnectionInitializer>();
        clientTypeToInitializer.putAll(this.m_agent.getConnectionInitializers());
        clientTypeToInitializer.put("ClientType.Command.ShutDown", new IConnectionInitializer(){

            public void initConnection(Socket socket, BufferedReader reader) {
                Thread.currentThread().interrupt();
            }
        });
        this.setCommunicator(new Communicator(port, this.getClass().getClassLoader(), clientTypeToInitializer));
        this.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)new CommunicationListener());
        this.logRunning();
        this.logStartListening();
        return this.getCommunicator().run();
    }

    private void initAutConnectionSocket() throws IOException, JBVersionException {
        this.setAutCommunicator(new Communicator(0, this.getClass().getClassLoader()));
        this.getAutCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)new CommunicationListener());
        this.getAutCommunicator().run();
    }

    private void showUserInfo(String infoMessage) {
        if (this.m_verbosity.compareTo(Verbosity.QUIET) <= 0) {
            System.out.println(infoMessage);
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {}
            IsAliveThread t = new IsAliveThread(){

                public void run() {
                    try {
                        3.sleep((long)10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.getRootFrame().dispose();
                        }
                    });
                }
            };
            t.start();
            JOptionPane.showMessageDialog(null, String.valueOf(infoMessage) + I18n.getString((String)"AUTAgent.dialogClose"), I18n.getString((String)"AUTAgent.failedStartDialogTitle"), 1);
        }
    }

    private void logRunning() {
        if (log.isInfoEnabled()) {
            log.info(NLS.bind((String)Messages.RunningVM, (Object)System.getProperty("java.version")));
        }
    }

    private void logStartListening() {
        if (log.isInfoEnabled()) {
            log.info(NLS.bind((String)Messages.ListeningToPort, (Object)this.getCommunicator().getLocalPort()));
        }
    }

    public AutAgent getAgent() {
        return this.m_agent;
    }

    private static class AUTWatcher
    extends IsAliveThread {
        private final Object m_autServerLock = new Object();
        private Process m_autProcess;
        private int m_autExitValue;
        private String m_errorMessage;
        private String m_errorLog;
        private boolean m_isExpectingAUTServerStop;
        private boolean m_isAgentSet;
        private CommunicationHelper m_messenger;
        private AutIdentifier m_autId;

        public AUTWatcher(Process autProcess, boolean isAgentSet, CommunicationHelper messenger, AutIdentifier autId) {
            super("AUTWatcher");
            this.m_autProcess = autProcess;
            this.m_isAgentSet = isAgentSet;
            this.m_messenger = messenger;
            this.m_autId = autId;
        }

        private void handleStoppedAUTServer() {
            if (log.isInfoEnabled()) {
                log.info(NLS.bind((String)Messages.SendMessageToClient, (Object)this.m_autExitValue));
            }
            StartAUTServerStateMessage message = null;
            ChooseCheckModeDialogBP.getInstance().closeDialog();
            ObservationConsoleBP.getInstance().closeShell();
            switch (this.m_autExitValue) {
                case 0: {
                    log.info(Messages.RegularTermination);
                    break;
                }
                case 25: {
                    message = new StartAUTServerStateMessage(1, Messages.AutStartError);
                    break;
                }
                case 1: {
                    if (this.m_isAgentSet && this.m_errorMessage != null) {
                        message = new StartAUTServerStateMessage(14, Messages.InvalidJDK);
                        break;
                    }
                    message = this.createInvalidArgumentMessage();
                    break;
                }
                case 2: {
                    message = new StartAUTServerStateMessage(11, Messages.InvalidNumOfArguments);
                    break;
                }
                case 10: {
                    message = new StartAUTServerStateMessage(10, Messages.UnknowIteClient);
                    break;
                }
                case 11: {
                    message = new StartAUTServerStateMessage(10, Messages.CommunicationError);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    message = new StartAUTServerStateMessage(5, Messages.SecuritiViolation);
                    break;
                }
                case 3: 
                case 12: {
                    break;
                }
                case 4: {
                    message = new StartAUTServerStateMessage(15, Messages.UnsupportedClass);
                    break;
                }
                case 24: {
                    message = this.m_messenger.handleAutRestart();
                    break;
                }
                case 134: {
                    message = new StartAUTServerStateMessage(10, Messages.AddressAlreadyInUse);
                    break;
                }
                default: {
                    message = this.handleGlobalError();
                }
            }
            message.setAutId(this.m_autId);
            this.appendErrorLog(message);
            this.m_messenger.sendStoppedAUTServerMessage(message);
        }

        private void appendErrorLog(StartAUTServerStateMessage message) {
            if (StringUtils.isNotBlank((String)this.m_errorLog)) {
                StringBuilder builder = new StringBuilder(message.getDescription());
                builder.append("\n");
                builder.append(" ");
                builder.append(this.m_errorLog);
                message.setDescription(builder.toString());
            }
        }

        private StartAUTServerStateMessage createInvalidArgumentMessage() {
            return new StartAUTServerStateMessage(11, Messages.InvalidArguments);
        }

        private StartAUTServerStateMessage handleGlobalError() {
            String message = NLS.bind((String)Messages.UnknowExitCode, (Object)this.m_autExitValue);
            log.error(message);
            return new StartAUTServerStateMessage(1, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SysoRedirect dn;
                Object object = this.m_autServerLock;
                synchronized (object) {
                    dn = new SysoRedirect(this.m_autProcess.getErrorStream(), Messages.AutsSysError);
                    dn.start();
                    new SysoRedirect(this.m_autProcess.getInputStream(), Messages.AutsSysOut).start();
                }
                this.m_autExitValue = this.m_autProcess.waitFor();
                this.m_errorMessage = dn.getLine();
                this.m_errorLog = dn.getTruncatedLog();
                object = this.m_autServerLock;
                synchronized (object) {
                    this.m_autProcess = null;
                }
                if (log.isInfoEnabled()) {
                    log.info(NLS.bind((String)Messages.VmStopped, (Object)this.m_autExitValue));
                }
                if (!this.m_isExpectingAUTServerStop) {
                    this.handleStoppedAUTServer();
                }
                this.m_isExpectingAUTServerStop = false;
            }
            catch (InterruptedException ie) {
                log.info(Messages.ObservingInterrupted, (Throwable)ie);
            }
            catch (NullPointerException npe) {
                log.debug(Messages.TerminatedProcess, (Throwable)npe);
            }
        }
    }

    private class CommunicationHelper {
        private CommunicationHelper() {
        }

        public void sendStoppedAUTServerMessage(StartAUTServerStateMessage message) {
            if (message != null) {
                try {
                    AutStarter.this.getCommunicator().send((Message)message);
                }
                catch (CommunicationException communicationException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        }

        public StartAUTServerStateMessage handleAutRestart() {
            StartAUTServerStateMessage message = null;
            AutStarter.this.getAutCommunicator().close();
            AutStarter.this.getAutCommunicator().getConnectionManager().remove(AutStarter.this.getAutCommunicator().getConnection());
            try {
                AutStarter.this.initAutConnectionSocket();
            }
            catch (JBVersionException jBVersionException) {
                message = new StartAUTServerStateMessage(10, Messages.VersionException);
            }
            catch (IOException iOException) {
                message = new StartAUTServerStateMessage(10, Messages.IoException);
            }
            return message;
        }
    }

    private class CommunicationListener
    implements ICommunicationErrorListener {
        private CommunicationListener() {
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            log.error(Messages.ConnectionErrorInServer);
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                try {
                    log.info(NLS.bind((String)Messages.AcceptedConnectionFrom, (Object[])new Object[]{inetAddress.getHostName(), port}));
                }
                catch (SecurityException se) {
                    log.warn(Messages.SecuritiViolationWhileGettingHostName, (Throwable)se);
                }
            }
        }

        public void acceptingFailed(int port) {
            log.error(NLS.bind((String)Messages.AcceptingFailed, (Object)port));
        }

        public void sendFailed(Message message) {
            log.warn(NLS.bind((String)Messages.SendingMessageFailed, (Object)message));
        }

        public void shutDown() {
            log.info(Messages.ConnectionClosed);
        }
    }

    public static enum Verbosity {
        QUIET,
        NORMAL,
        VERBOSE;

    }
}

