/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.discovery.core.util.ITransportService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class P2TransportService
implements ITransportService {
    private Object transport;
    private Method downloadMethod;
    private Method streamMethod;
    private Method getLastModifiedMethod;

    public P2TransportService() throws ClassNotFoundException {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.internal.p2.repository.RepositoryTransport");
                Method getInstanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
                this.transport = getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                clazz = Class.forName("org.eclipse.equinox.internal.p2.repository.Transport");
                this.transport = this.getTransportEclipse37();
            }
            if (this.transport == null) {
                throw new ClassNotFoundException("Failed to load P2 transport");
            }
            this.downloadMethod = clazz.getDeclaredMethod("download", URI.class, OutputStream.class, IProgressMonitor.class);
            this.streamMethod = clazz.getDeclaredMethod("stream", URI.class, IProgressMonitor.class);
            this.getLastModifiedMethod = clazz.getDeclaredMethod("getLastModified", URI.class, IProgressMonitor.class);
        }
        catch (LinkageError e) {
            throw new ClassNotFoundException("Failed to load P2 transport", e);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Failed to load P2 transport", e);
        }
    }

    private Object getTransportEclipse37() throws Exception {
        BundleContext bundleContext = Platform.getBundle((String)"org.eclipse.core.runtime").getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference("org.eclipse.equinox.p2.core.IProvisioningAgent");
        if (serviceReference != null) {
            try {
                Object agent = bundleContext.getService(serviceReference);
                if (agent != null) {
                    Method method = agent.getClass().getDeclaredMethod("getService", String.class);
                    Object object = method.invoke(agent, "org.eclipse.equinox.internal.p2.repository.Transport");
                    return object;
                }
                throw new Exception("Provisioning agent instance not available");
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        throw new Exception("Service reference for org.eclipse.equinox.p2.core.IProvisioningAgent not available");
    }

    @Override
    public IStatus download(URI uri, OutputStream out, IProgressMonitor monitor) {
        try {
            return (IStatus)this.downloadMethod.invoke(this.transport, uri, out, monitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream stream(URI uri, IProgressMonitor monitor) throws IOException, CoreException {
        try {
            return (InputStream)this.streamMethod.invoke(this.transport, uri, monitor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLastModified(URI location, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            return (Long)this.getLastModifiedMethod.invoke(this.transport, location, monitor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

