/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotAUTAgentMessage;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotAUTAgentResponseMessage;
import org.eclipse.jubula.tools.internal.serialisation.SerializedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeScreenshotAUTAgentCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(TakeScreenshotAUTAgentCommand.class);
    private TakeScreenshotAUTAgentMessage m_message;

    public TakeScreenshotAUTAgentMessage getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        Validate.isTrue((boolean)(message instanceof TakeScreenshotAUTAgentMessage));
        this.m_message = (TakeScreenshotAUTAgentMessage)message;
    }

    public Message execute() {
        TakeScreenshotAUTAgentResponseMessage response = new TakeScreenshotAUTAgentResponseMessage();
        try {
            BufferedImage image = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
            SerializedImage computedSerializeImage = SerializedImage.computeSerializeImage((BufferedImage)image);
            response.setScreenshot(computedSerializeImage);
        }
        catch (AWTException e) {
            LOG.error("Error occurred while trying to take screenshot.", (Throwable)e);
            response.setScreenshot(null);
        }
        return response;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

