/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.newcap;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.CNTypeProblemDialog;
import org.eclipse.jubula.client.ui.rcp.dialogs.NewCAPDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.NewTestCaseHandlerTCEditor;
import org.eclipse.jubula.client.ui.rcp.utils.NodeTargetCalculator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewCAP
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractTestCaseEditor) {
            final AbstractTestCaseEditor tce = (AbstractTestCaseEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    ISpecTestCasePO cfr_ignored_0 = (ISpecTestCasePO)workingPo;
                    IStructuredSelection selection = NewCAP.this.getSelection();
                    INodePO selected = (INodePO)selection.getFirstElement();
                    NodeTargetCalculator.NodeTarget tar = NewTestCaseHandlerTCEditor.getPositionToInsert(selected, false);
                    if (tar != null) {
                        NewCAP.this.addCap(tar.getNode(), tar.getPos(), tce);
                        tce.getTreeViewer().setExpandedState((Object)tar.getNode().getParentNode(), true);
                    }
                }
            });
        }
        return null;
    }

    private void addCap(INodePO target, Integer position, AbstractTestCaseEditor tce) {
        NewCAPDialog dialog = new NewCAPDialog(this.getActiveShell(), target, (IComponentNameCache)tce.getCompNameCache());
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String componentType = dialog.getComponentType();
        String capName = dialog.getCapName();
        String action = dialog.getActionName();
        String componentName = dialog.getComponentName();
        ICapPO cap = CapBP.createCapWithDefaultParams((String)capName, (String)componentName, (String)componentType, (String)action);
        IWritableComponentNameCache cache = tce.getCompNameCache();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Component comp = compSystem.findComponent(componentType);
        cap.setComponentName(null);
        boolean hasDefaultMapping = false;
        if (comp.isConcrete()) {
            hasDefaultMapping = ((ConcreteComponent)comp).hasDefaultMapping();
        }
        if (!hasDefaultMapping) {
            ComponentNamesBP.setCompName((ICapPO)cap, (String)componentName, (ComponentNamesBP.CompNameCreationContext)ComponentNamesBP.CompNameCreationContext.STEP, (IWritableComponentNameCache)cache);
            target.addNode(position.intValue(), (INodePO)cap);
            if (!CNTypeProblemDialog.noProblemOrIgnore(cache, target.getSpecAncestor())) {
                target.removeNode((INodePO)cap);
                return;
            }
        } else {
            target.addNode(position.intValue(), (INodePO)cap);
        }
        tce.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)cap, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
    }
}

