/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.ObjectMapping;
import org.eclipse.jubula.client.archive.schema.OmCategory;
import org.eclipse.jubula.client.archive.schema.OmEntry;
import org.eclipse.jubula.client.archive.schema.Project;

public class ObjectMappingAssoziationConverter
extends AbstractXmlConverter {
    private static final int HIGHEST_META_DATA_VERSION_NUMBER = 6;

    @Override
    protected boolean conversionIsNecessary(Project xml) {
        return xml.getMetaDataVersion() <= 6;
    }

    @Override
    protected void convertImpl(Project xml) {
        for (Aut aut : xml.getAutList()) {
            ObjectMapping om = aut.getObjectMapping();
            OmCategory rootCategory = om.getMapped();
            this.convertCategory(rootCategory);
        }
    }

    private void convertCategory(OmCategory category) {
        List<OmEntry> entryList = category.getAssociationList();
        for (OmEntry entry : entryList) {
            List<String> logicalNameList = entry.getLogicalNameList();
            HashSet<String> set = new HashSet<String>(logicalNameList);
            if (logicalNameList.size() == set.size()) continue;
            logicalNameList.clear();
            logicalNameList.addAll(set);
        }
        List<OmCategory> subcategoryList = category.getCategoryList();
        for (OmCategory subcategory : subcategoryList) {
            this.convertCategory(subcategory);
        }
    }
}

