/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class ReplaceWithOursTheirsMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator locator) {
        this.serviceLocator = locator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        IHandlerService handlerService = CommonUtils.getService(this.serviceLocator, IHandlerService.class);
        IStructuredSelection selection = SelectionUtils.getSelection(handlerService.getCurrentState());
        IPath[] locations = SelectionUtils.getSelectedLocations(selection);
        if (locations.length == 0) {
            return new IContributionItem[0];
        }
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(locations));
        if (pathsByRepository.size() == 1) {
            Repository repository = (Repository)pathsByRepository.keySet().iterator().next();
            Collection paths = (Collection)pathsByRepository.get(repository);
            if (paths.size() == 1) {
                String path = (String)paths.iterator().next();
                items.addAll(ReplaceWithOursTheirsMenu.createSpecificOursTheirsItems(repository, path));
            } else if (paths.size() > 1) {
                items.addAll(ReplaceWithOursTheirsMenu.createUnspecificOursTheirsItems(Arrays.asList(locations)));
            }
        }
        return items.toArray(new IContributionItem[0]);
    }

    private static Collection<IContributionItem> createSpecificOursTheirsItems(Repository repository, String path) {
        Set<Path> paths = Collections.singleton(new Path(new File(repository.getWorkTree(), path).getAbsolutePath()));
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        try {
            RevUtils.ConflictCommits conflictCommits = RevUtils.getConflictCommits((Repository)repository, (String)path);
            RevCommit ourCommit = conflictCommits.getOurCommit();
            RevCommit theirCommit = conflictCommits.getTheirCommit();
            if (ourCommit != null) {
                result.add(ReplaceWithOursTheirsMenu.createOursItem(ReplaceWithOursTheirsMenu.formatCommit(UIText.ReplaceWithOursTheirsMenu_OursWithCommitLabel, ourCommit), paths));
            } else {
                result.add(ReplaceWithOursTheirsMenu.createOursItem(UIText.ReplaceWithOursTheirsMenu_OursWithoutCommitLabel, paths));
            }
            if (theirCommit != null) {
                result.add(ReplaceWithOursTheirsMenu.createTheirsItem(ReplaceWithOursTheirsMenu.formatCommit(UIText.ReplaceWithOursTheirsMenu_TheirsWithCommitLabel, theirCommit), paths));
            } else {
                result.add(ReplaceWithOursTheirsMenu.createTheirsItem(UIText.ReplaceWithOursTheirsMenu_TheirsWithoutCommitLabel, paths));
            }
            return result;
        }
        catch (IOException e) {
            Activator.logError(UIText.ReplaceWithOursTheirsMenu_CalculatingOursTheirsCommitsError, e);
            return ReplaceWithOursTheirsMenu.createUnspecificOursTheirsItems(paths);
        }
    }

    private static Collection<IContributionItem> createUnspecificOursTheirsItems(Collection<IPath> paths) {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        result.add(ReplaceWithOursTheirsMenu.createOursItem(UIText.ReplaceWithOursTheirsMenu_OursWithoutCommitLabel, paths));
        result.add(ReplaceWithOursTheirsMenu.createTheirsItem(UIText.ReplaceWithOursTheirsMenu_TheirsWithoutCommitLabel, paths));
        return result;
    }

    private static IContributionItem createOursItem(String label, Collection<IPath> paths) {
        return new ActionContributionItem((IAction)new ReplaceAction(label, DiscardChangesOperation.Stage.OURS, paths));
    }

    private static IContributionItem createTheirsItem(String label, Collection<IPath> paths) {
        return new ActionContributionItem((IAction)new ReplaceAction(label, DiscardChangesOperation.Stage.THEIRS, paths));
    }

    private static String formatCommit(String format, RevCommit commit) {
        String message = Utils.shortenText((String)commit.getShortMessage(), (int)60);
        return NLS.bind((String)format, (Object)commit.abbreviate(7).name(), (Object)message);
    }

    private static class ReplaceAction
    extends Action {
        private final DiscardChangesOperation.Stage stage;
        private final Collection<IPath> paths;

        public ReplaceAction(String text, DiscardChangesOperation.Stage stage, Collection<IPath> paths) {
            super(text);
            this.stage = stage;
            this.paths = paths;
        }

        public void run() {
            final DiscardChangesOperation operation = new DiscardChangesOperation(this.paths);
            operation.setStage(this.stage);
            String jobname = UIText.DiscardChangesAction_discardChanges;
            WorkspaceJob job = new WorkspaceJob(jobname){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    try {
                        operation.execute(monitor);
                    }
                    catch (CoreException e) {
                        return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (JobFamilies.DISCARD_CHANGES.equals(family)) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            job.setUser(true);
            job.setRule(operation.getSchedulingRule());
            job.schedule();
        }
    }
}

