/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkTokenScanner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.util.IntList;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class SpellcheckableMessageArea
extends Composite {
    static final int MAX_LINE_WIDTH = 72;
    private static final Pattern TRAILING_WHITE_SPACE_ON_LINES = Pattern.compile("\\h+$", 8);
    private static final Pattern TRAILING_NEWLINES = Pattern.compile("\\v+$");
    private final HyperlinkSourceViewer sourceViewer;
    private TextSourceViewerConfiguration configuration;
    private BidiSegmentListener hardWrapSegmentListener;
    private int brokenBidiPlatformTextWidth;
    private IAction contentAssistAction;

    public SpellcheckableMessageArea(Composite parent, String initialText) {
        this(parent, initialText, 2048);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, int styles) {
        this(parent, initialText, false, styles);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, boolean readOnly, int styles) {
        super(parent, styles);
        this.setLayout((Layout)new FillLayout());
        AnnotationModel annotationModel = new AnnotationModel();
        this.sourceViewer = new HyperlinkSourceViewer(this, null, 578){

            @Override
            protected void handleJFacePreferencesChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.textfont".equals(event.getProperty())) {
                    Font jFaceFont;
                    Font themeFont = UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont");
                    if (themeFont.equals((Object)(jFaceFont = JFaceResources.getTextFont()))) {
                        this.setFont(jFaceFont);
                    }
                } else {
                    super.handleJFacePreferencesChange(event);
                }
            }
        };
        this.getTextWidget().setAlwaysShowScrollBars(false);
        this.getTextWidget().setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont"));
        this.sourceViewer.setDocument((IDocument)new Document());
        int endSpacing = 2;
        int textWidth = this.getCharWidth() * 72 + endSpacing;
        int textHeight = this.getLineHeight() * 7;
        Point size = this.getTextWidget().computeSize(textWidth, textHeight);
        this.getTextWidget().setSize(size);
        this.computeBrokenBidiPlatformTextWidth(size.x);
        this.getTextWidget().setEditable(!readOnly);
        this.createMarginPainter();
        this.configureHardWrap();
        final IPropertyChangeListener propertyChangeListener = event -> {
            if ("commit_dialog_hard_wrap_message".equals(event.getProperty())) {
                this.getDisplay().asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.configureHardWrap();
                        if (this.brokenBidiPlatformTextWidth != -1) {
                            this.layout();
                        }
                    }
                });
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
        final IPropertyChangeListener themeListener = event -> {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property) || "org.eclipse.egit.ui.CommitMessageEditorFont".equals(property)) {
                Font themeFont = UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont");
                this.getDisplay().asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.sourceViewer.setFont(themeFont);
                    }
                });
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(themeListener);
        final SourceViewerDecorationSupport support = this.configureAnnotationPreferences();
        Document document = new Document(initialText);
        this.configuration = new HyperlinkSourceViewer.Configuration(EditorsUI.getPreferenceStore()){

            public int getHyperlinkStateMask(ISourceViewer targetViewer) {
                if (!targetViewer.isEditable()) {
                    return 0;
                }
                return super.getHyperlinkStateMask(targetViewer);
            }

            @Override
            protected Map getHyperlinkDetectorTargets(ISourceViewer targetViewer) {
                return SpellcheckableMessageArea.this.getHyperlinkTargets();
            }

            public IReconciler getReconciler(ISourceViewer viewer) {
                if (!SpellcheckableMessageArea.this.isEditable(viewer)) {
                    return null;
                }
                return super.getReconciler((ISourceViewer)SpellcheckableMessageArea.this.sourceViewer);
            }

            public IContentAssistant getContentAssistant(ISourceViewer viewer) {
                if (!viewer.isEditable()) {
                    return null;
                }
                IContentAssistant assistant = SpellcheckableMessageArea.this.createContentAssistant(viewer);
                if (assistant != null) {
                    SpellcheckableMessageArea.this.contentAssistAction = SpellcheckableMessageArea.this.createContentAssistAction((SourceViewer)SpellcheckableMessageArea.this.sourceViewer);
                }
                return assistant;
            }

            public IPresentationReconciler getPresentationReconciler(ISourceViewer viewer) {
                PresentationReconciler reconciler = new PresentationReconciler();
                reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(viewer));
                DefaultDamagerRepairer hyperlinkDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer));
                reconciler.setDamager((IPresentationDamager)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                reconciler.setRepairer((IPresentationRepairer)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                return reconciler;
            }
        };
        this.sourceViewer.configure((SourceViewerConfiguration)this.configuration);
        this.sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        this.configureContextMenu();
        this.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                support.uninstall();
                Activator.getDefault().getPreferenceStore().removePropertyChangeListener(propertyChangeListener);
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(themeListener);
            }
        });
    }

    private void computeBrokenBidiPlatformTextWidth(int textWidth) {
        class BidiSegmentListenerTester
        implements BidiSegmentListener {
            boolean called;

            BidiSegmentListenerTester() {
            }

            public void lineGetSegments(BidiSegmentEvent event) {
                this.called = true;
            }
        }
        BidiSegmentListenerTester tester = new BidiSegmentListenerTester();
        StyledText textWidget = this.getTextWidget();
        textWidget.addBidiSegmentListener((BidiSegmentListener)tester);
        textWidget.setText(" ");
        textWidget.computeSize(-1, -1);
        textWidget.removeBidiSegmentListener((BidiSegmentListener)tester);
        this.brokenBidiPlatformTextWidth = tester.called ? -1 : textWidth;
    }

    private boolean isEditable(ISourceViewer viewer) {
        return viewer != null && viewer.getTextWidget().getEditable();
    }

    private void configureHardWrap() {
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            if (this.hardWrapSegmentListener == null) {
                final StyledText textWidget = this.getTextWidget();
                this.hardWrapSegmentListener = new BidiSegmentListener(){

                    public void lineGetSegments(BidiSegmentEvent e) {
                        int footerOffset;
                        if (e.widget == textWidget && (footerOffset = CommonUtils.getFooterOffset(textWidget.getText())) >= 0 && e.lineOffset >= footerOffset) {
                            return;
                        }
                        int[] segments = SpellcheckableMessageArea.calculateWrapOffsets(e.lineText, 72);
                        if (segments != null) {
                            char[] segmentsChars = new char[segments.length];
                            Arrays.fill(segmentsChars, '\n');
                            e.segments = segments;
                            e.segmentsChars = segmentsChars;
                        }
                    }
                };
                textWidget.addBidiSegmentListener(this.hardWrapSegmentListener);
                textWidget.setText(textWidget.getText());
                if (this.brokenBidiPlatformTextWidth != -1) {
                    Layout restrictedWidthLayout = new Layout(){

                        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                            Point size = SpellcheckableMessageArea.this.getSize();
                            Rectangle trim = SpellcheckableMessageArea.this.computeTrim(0, 0, 0, 0);
                            size.x -= trim.width;
                            size.y -= trim.height;
                            if (size.x > SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth) {
                                size.x = SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth;
                            }
                            return size;
                        }

                        protected void layout(Composite composite, boolean flushCache) {
                            Point size = this.computeSize(composite, -1, -1, flushCache);
                            textWidget.setBounds(0, 0, size.x, size.y);
                        }
                    };
                    this.setLayout(restrictedWidthLayout);
                }
            }
        } else if (this.hardWrapSegmentListener != null) {
            StyledText textWidget = this.getTextWidget();
            textWidget.removeBidiSegmentListener(this.hardWrapSegmentListener);
            textWidget.setText(textWidget.getText());
            this.hardWrapSegmentListener = null;
            if (this.brokenBidiPlatformTextWidth != -1) {
                this.setLayout((Layout)new FillLayout());
            }
        }
    }

    private TextViewerAction createFromActionFactory(ActionFactory factory, int operationCode) {
        ActionFactory.IWorkbenchAction template = factory.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        TextViewerAction action = new TextViewerAction((ITextOperationTarget)this.sourceViewer, operationCode);
        action.setText(template.getText());
        action.setImageDescriptor(template.getImageDescriptor());
        action.setDisabledImageDescriptor(template.getDisabledImageDescriptor());
        action.setActionDefinitionId(template.getActionDefinitionId());
        template.dispose();
        return action;
    }

    private void configureContextMenu() {
        QuickfixAction quickFixAction;
        TextViewerAction pasteAction;
        TextViewerAction redoAction;
        TextViewerAction undoAction;
        TextViewerAction cutAction;
        boolean editable = this.isEditable((ISourceViewer)this.sourceViewer);
        if (editable) {
            cutAction = this.createFromActionFactory(ActionFactory.CUT, 3);
            undoAction = this.createFromActionFactory(ActionFactory.UNDO, 1);
            redoAction = this.createFromActionFactory(ActionFactory.REDO, 2);
            pasteAction = this.createFromActionFactory(ActionFactory.PASTE, 5);
            quickFixAction = new QuickfixAction((ITextOperationTarget)this.sourceViewer);
        } else {
            cutAction = null;
            undoAction = null;
            redoAction = null;
            pasteAction = null;
            quickFixAction = null;
        }
        final TextViewerAction copyAction = this.createFromActionFactory(ActionFactory.COPY, 4);
        TextViewerAction selectAllAction = this.createFromActionFactory(ActionFactory.SELECT_ALL, 7);
        final TextEditorPropertyAction showWhitespaceAction = new TextEditorPropertyAction(UIText.SpellcheckableMessageArea_showWhitespace, (SourceViewer)this.sourceViewer, "showWhitespaceCharacters"){
            private IPainter whitespaceCharPainter;

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals(this.getPreferenceKey()) || "showLeadingSpaces".equals(property) || "showEnclosedSpaces".equals(property) || "showTrailingSpaces".equals(property) || "showLeadingIdeographicSpaces".equals(property) || "showEnclosedIdeographicSpaces".equals(property) || "showTrailingIdeographicSpaces".equals(property) || "showLeadingTabs".equals(property) || "showEnclosedTabs".equals(property) || "showTrailingTabs".equals(property) || "showCarriageReturn".equals(property) || "showLineFeed".equals(property) || "whitespaceCharacterAlphaValue".equals(property)) {
                    this.synchronizeWithPreference();
                }
            }

            @Override
            protected void toggleState(boolean checked) {
                if (checked) {
                    this.installPainter();
                } else {
                    this.uninstallPainter();
                }
            }

            private void installPainter() {
                Assert.isTrue((this.whitespaceCharPainter == null ? 1 : 0) != 0);
                ITextViewer v = this.getTextViewer();
                if (v instanceof ITextViewerExtension2) {
                    IPreferenceStore store = this.getStore();
                    this.whitespaceCharPainter = new WhitespaceCharacterPainter(v, store.getBoolean("showLeadingSpaces"), store.getBoolean("showEnclosedSpaces"), store.getBoolean("showTrailingSpaces"), store.getBoolean("showLeadingIdeographicSpaces"), store.getBoolean("showEnclosedIdeographicSpaces"), store.getBoolean("showTrailingIdeographicSpaces"), store.getBoolean("showLeadingTabs"), store.getBoolean("showEnclosedTabs"), store.getBoolean("showTrailingTabs"), store.getBoolean("showCarriageReturn"), store.getBoolean("showLineFeed"), store.getInt("whitespaceCharacterAlphaValue"));
                    ((ITextViewerExtension2)v).addPainter(this.whitespaceCharPainter);
                }
            }

            private void uninstallPainter() {
                if (this.whitespaceCharPainter == null) {
                    return;
                }
                ITextViewer v = this.getTextViewer();
                if (v instanceof ITextViewerExtension2) {
                    ((ITextViewerExtension2)v).removePainter(this.whitespaceCharPainter);
                }
                this.whitespaceCharPainter.deactivate(true);
                this.whitespaceCharPainter = null;
            }
        };
        MenuManager contextMenu = new MenuManager();
        if (cutAction != null) {
            contextMenu.add((IAction)cutAction);
        }
        contextMenu.add((IAction)copyAction);
        if (pasteAction != null) {
            contextMenu.add((IAction)pasteAction);
        }
        contextMenu.add((IAction)selectAllAction);
        if (undoAction != null) {
            contextMenu.add((IAction)undoAction);
        }
        if (redoAction != null) {
            contextMenu.add((IAction)redoAction);
        }
        contextMenu.add((IContributionItem)new Separator());
        contextMenu.add((IAction)showWhitespaceAction);
        contextMenu.add((IContributionItem)new Separator());
        if (editable) {
            final SubMenuManager quickFixMenu = new SubMenuManager((IMenuManager)contextMenu);
            quickFixMenu.setVisible(true);
            quickFixMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    quickFixMenu.removeAll();
                    SpellcheckableMessageArea.this.addProposals(quickFixMenu);
                }
            });
        }
        StyledText textWidget = this.getTextWidget();
        ArrayList<Object> globalActions = new ArrayList<Object>();
        if (editable) {
            globalActions.add((Object)cutAction);
            globalActions.add((Object)pasteAction);
            globalActions.add((Object)undoAction);
            globalActions.add((Object)redoAction);
            globalActions.add((Object)quickFixAction);
        }
        globalActions.add((Object)copyAction);
        globalActions.add((Object)selectAllAction);
        if (this.contentAssistAction != null) {
            globalActions.add(this.contentAssistAction);
        }
        ActionUtils.setGlobalActions((Control)textWidget, globalActions, this.getHandlerService());
        textWidget.setMenu(contextMenu.createContextMenu((Control)textWidget));
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (cutAction != null) {
                    cutAction.update();
                }
                copyAction.update();
            }
        });
        if (editable) {
            this.sourceViewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    if (undoAction != null) {
                        undoAction.update();
                    }
                    if (redoAction != null) {
                        redoAction.update();
                    }
                }
            });
        }
        textWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                showWhitespaceAction.dispose();
            }
        });
    }

    private void addProposals(SubMenuManager quickFixMenu) {
        IAnnotationModel sourceModel = this.sourceViewer.getAnnotationModel();
        if (sourceModel == null) {
            return;
        }
        Iterator annotationIterator = sourceModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            ICompletionProposal[] proposals;
            boolean isFixable;
            Annotation annotation = (Annotation)annotationIterator.next();
            boolean isDeleted = annotation.isMarkedDeleted();
            boolean isIncluded = !isDeleted && this.includes(sourceModel.getPosition(annotation), this.getTextWidget().getCaretOffset());
            boolean bl = isFixable = isIncluded && this.sourceViewer.getQuickAssistAssistant().canFix(annotation);
            if (!isFixable) continue;
            IQuickAssistProcessor processor = this.sourceViewer.getQuickAssistAssistant().getQuickAssistProcessor();
            IQuickAssistInvocationContext context = this.sourceViewer.getQuickAssistInvocationContext();
            ICompletionProposal[] iCompletionProposalArray = proposals = processor.computeQuickAssistProposals(context);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                quickFixMenu.add(this.createQuickFixAction(proposal));
                ++n2;
            }
        }
    }

    private boolean includes(Position position, int caretOffset) {
        return position != null && (position.includes(caretOffset) || position.offset + position.length == caretOffset);
    }

    private IAction createQuickFixAction(final ICompletionProposal proposal) {
        return new Action(proposal.getDisplayString()){

            public void run() {
                proposal.apply(SpellcheckableMessageArea.this.sourceViewer.getDocument());
            }

            public ImageDescriptor getImageDescriptor() {
                Image image = proposal.getImage();
                if (image != null) {
                    return ImageDescriptor.createFromImage((Image)image);
                }
                return null;
            }
        };
    }

    protected IHandlerService getHandlerService() {
        return CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), IHandlerService.class);
    }

    private SourceViewerDecorationSupport configureAnnotationPreferences() {
        ISharedTextColors textColors = EditorsUI.getSharedTextColors();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)annotationAccess, textColors);
        List annotationPreferences = new MarkerAnnotationPreferences().getAnnotationPreferences();
        Iterator e = annotationPreferences.iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        return support;
    }

    protected void createMarginPainter() {
        MarginPainter marginPainter = new MarginPainter((ITextViewer)this.sourceViewer);
        marginPainter.setMarginRulerColumn(72);
        marginPainter.setMarginRulerColor(Display.getDefault().getSystemColor(15));
        this.sourceViewer.addPainter((IPainter)marginPainter);
    }

    private int getCharWidth() {
        GC gc = new GC((Drawable)this.getTextWidget());
        int charWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return charWidth;
    }

    private int getLineHeight() {
        return this.getTextWidget().getLineHeight();
    }

    private static boolean shouldHardWrap() {
        return Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_hard_wrap_message");
    }

    public StyledText getTextWidget() {
        return this.sourceViewer.getTextWidget();
    }

    private IAction createContentAssistAction(SourceViewer viewer) {
        TextViewerAction proposalAction = new TextViewerAction((ITextOperationTarget)viewer, 13);
        proposalAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        return proposalAction;
    }

    public String getCommitMessage() {
        String text = this.getText();
        text = Utils.normalizeLineEndings((String)text);
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            text = SpellcheckableMessageArea.wrapCommitMessage(text);
        }
        text = TRAILING_WHITE_SPACE_ON_LINES.matcher(text).replaceAll("");
        text = TRAILING_NEWLINES.matcher(text).replaceFirst("\n");
        return text;
    }

    protected static String wrapCommitMessage(String text) {
        int footerStart = CommonUtils.getFooterOffset(text);
        if (footerStart < 0) {
            return SpellcheckableMessageArea.hardWrap(text);
        }
        String footer = text.substring(footerStart);
        text = SpellcheckableMessageArea.hardWrap(text.substring(0, footerStart));
        return String.valueOf(text) + footer;
    }

    protected static String hardWrap(String text) {
        int[] wrapOffsets = SpellcheckableMessageArea.calculateWrapOffsets(text, 72);
        if (wrapOffsets != null) {
            StringBuilder builder = new StringBuilder(text.length() + wrapOffsets.length);
            int prev = 0;
            int[] nArray = wrapOffsets;
            int n = wrapOffsets.length;
            int n2 = 0;
            while (n2 < n) {
                int cur = nArray[n2];
                builder.append(text.substring(prev, cur));
                int j = cur;
                while (j > prev && builder.charAt(builder.length() - 1) == ' ') {
                    builder.deleteCharAt(builder.length() - 1);
                    --j;
                }
                builder.append('\n');
                prev = cur;
                ++n2;
            }
            builder.append(text.substring(prev));
            return builder.toString();
        }
        return text;
    }

    protected Map<String, IAdaptable> getHyperlinkTargets() {
        return Collections.singletonMap("org.eclipse.ui.DefaultTextEditor", this.getDefaultTarget());
    }

    protected IContentAssistant createContentAssistant(ISourceViewer viewer) {
        return null;
    }

    protected IAdaptable getDefaultTarget() {
        return null;
    }

    public String getText() {
        return this.getDocument().get();
    }

    public IDocument getDocument() {
        return this.sourceViewer.getDocument();
    }

    public void setText(String text) {
        if (text != null) {
            this.getDocument().set(text);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        StyledText textWidget = this.getTextWidget();
        textWidget.setBackground(color);
    }

    public boolean forceFocus() {
        return this.getTextWidget().setFocus();
    }

    public static int[] calculateWrapOffsets(String line, int maxLineLength) {
        if (line.length() == 0) {
            return null;
        }
        IntList wrapOffsets = new IntList();
        int wordStart = 0;
        int lineStart = 0;
        int length = line.length();
        int nofPreviousWordChars = 0;
        int nofCurrentWordChars = 0;
        int i = 0;
        while (i < length) {
            char ch = line.charAt(i);
            if (ch == ' ') {
                nofPreviousWordChars += nofCurrentWordChars;
                nofCurrentWordChars = 0;
            } else if (ch == '\n') {
                lineStart = i + 1;
                wordStart = i + 1;
                nofPreviousWordChars = 0;
                nofCurrentWordChars = 0;
            } else {
                if (nofCurrentWordChars == 0 && (nofPreviousWordChars > maxLineLength / 10 || nofPreviousWordChars > 0 && i - lineStart > maxLineLength / 2)) {
                    wordStart = i;
                }
                ++nofCurrentWordChars;
                if (i >= lineStart + maxLineLength && wordStart != lineStart) {
                    wrapOffsets.add(wordStart);
                    lineStart = wordStart;
                    nofPreviousWordChars = 0;
                    nofCurrentWordChars = 0;
                }
            }
            ++i;
        }
        int size = wrapOffsets.size();
        if (size == 0) {
            return null;
        }
        int[] result = new int[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = wrapOffsets.get(i2);
            ++i2;
        }
        return result;
    }

    private static class QuickfixAction
    extends Action {
        private final ITextOperationTarget textOperationTarget;

        public QuickfixAction(ITextOperationTarget target) {
            this.textOperationTarget = target;
            this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }

        public void run() {
            if (this.textOperationTarget.canDoOperation(22)) {
                this.textOperationTarget.doOperation(22);
            }
        }
    }

    private static abstract class TextEditorPropertyAction
    extends Action
    implements IPropertyChangeListener {
        private SourceViewer viewer;
        private String preferenceKey;
        private IPreferenceStore store;

        public TextEditorPropertyAction(String label, SourceViewer viewer, String preferenceKey) {
            super(label, 2);
            this.viewer = viewer;
            this.preferenceKey = preferenceKey;
            this.store = EditorsUI.getPreferenceStore();
            if (this.store != null) {
                this.store.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(this.getPreferenceKey())) {
                this.synchronizeWithPreference();
            }
        }

        protected void synchronizeWithPreference() {
            boolean checked = false;
            if (this.store != null) {
                checked = this.store.getBoolean(this.getPreferenceKey());
            }
            if (checked != this.isChecked()) {
                this.setChecked(checked);
                this.toggleState(checked);
            } else if (checked) {
                this.toggleState(false);
                this.toggleState(true);
            }
        }

        protected String getPreferenceKey() {
            return this.preferenceKey;
        }

        public void run() {
            this.toggleState(this.isChecked());
            if (this.store != null) {
                this.store.setValue(this.getPreferenceKey(), this.isChecked());
            }
        }

        public void dispose() {
            if (this.store != null) {
                this.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }

        protected abstract void toggleState(boolean var1);

        protected ITextViewer getTextViewer() {
            return this.viewer;
        }

        protected IPreferenceStore getStore() {
            return this.store;
        }
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextOperationTarget target, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = target;
            this.update();
        }

        public void update() {
            if (this.fOperationCode == 2) {
                return;
            }
            this.setEnabled(this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode));
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

