/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.model.elements.DebugElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class VariableLabelProvider
extends DebugElementLabelProvider {
    @Override
    protected RGB getBackground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IVariable variable;
        Object element = elementPath.getLastSegment();
        if (columnId != null && element instanceof IVariable && (variable = (IVariable)element).hasValueChanged()) {
            return DebugUIPlugin.getPreferenceColor("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB();
        }
        return super.getBackground(elementPath, presentationContext, columnId);
    }

    @Override
    protected RGB getForeground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IVariable variable;
        Object element = elementPath.getLastSegment();
        if (columnId == null && element instanceof IVariable && (variable = (IVariable)element).hasValueChanged()) {
            return DebugUIPlugin.getPreferenceColor("org.eclipse.debug.ui.changedDebugElement").getRGB();
        }
        return super.getForeground(elementPath, presentationContext, columnId);
    }

    @Override
    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        if (columnId == null || "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return super.getImageDescriptor(elementPath, presentationContext, columnId);
        }
        return null;
    }

    @Override
    protected FontData getFontData(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        return JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0];
    }

    @Override
    protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
        if (columnId == null) {
            return super.getLabel(elementPath, context, columnId);
        }
        IVariable variable = (IVariable)elementPath.getLastSegment();
        IValue value = variable.getValue();
        return this.getColumnText(variable, value, context, columnId);
    }

    protected String getColumnText(IVariable variable, IValue value, IPresentationContext context, String columnId) throws CoreException {
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return this.getVariableName(variable, context);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_TYPE".equals(columnId)) {
            return this.getVariableTypeName(variable, context);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(columnId)) {
            return this.getValueText(variable, value, context);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VALUE_TYPE".equals(columnId)) {
            return this.getValueTypeName(variable, value, context);
        }
        return null;
    }

    protected String getVariableName(IVariable variable, IPresentationContext context) throws CoreException {
        return variable.getName();
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        return variable.getReferenceTypeName();
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        return value.getReferenceTypeName();
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        return this.escapeSpecialChars(value.getValueString());
    }

    protected String escapeSpecialChars(String label) {
        return DefaultLabelProvider.escapeSpecialChars(label);
    }
}

