/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TmfProjectModelHelper {
    private static final String SHADOW_PROJECT_NAME_PREFIX = ".tracecompass-";

    public static @Nullable IProject getProjectFromShadowProject(IProject shadowProject) {
        if (shadowProject != null && TmfProjectModelHelper.isShadowProject(shadowProject)) {
            String projName = shadowProject.getName().substring(SHADOW_PROJECT_NAME_PREFIX.length());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(projName);
            if (project.exists()) {
                return project;
            }
        }
        return null;
    }

    public static boolean isShadowProject(@NonNull IProject project) {
        return project.getName().startsWith(SHADOW_PROJECT_NAME_PREFIX);
    }

    public static boolean shadowProjectExists(@NonNull IProject project) {
        IProject shadowProject = TmfProjectModelHelper.getShadowProject(project);
        return shadowProject.exists();
    }

    public static boolean shadowProjectAccessible(@NonNull IProject project) {
        IProject shadowProject = TmfProjectModelHelper.getShadowProject(project);
        return shadowProject.exists() && shadowProject.isAccessible();
    }

    public static String getShadowProjectName(String name) {
        return SHADOW_PROJECT_NAME_PREFIX + name;
    }

    public static IProject getShadowProject(IProject project) {
        return TmfProjectModelHelper.getShadowProject(project.getName());
    }

    public static IProject getShadowProject(String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProject(TmfProjectModelHelper.getShadowProjectName(name));
    }
}

