/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.viewers.IImageSave;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;

@NonNullByDefault
public final class SaveImageUtil {
    private SaveImageUtil() {
    }

    public static Action createSaveAction(final @Nullable String name, final Supplier<@Nullable IImageSave> controlSupplier) {
        Action saveAction = new Action(Messages.AbstractTimeGraphView_ExportImageActionText){

            public void run() {
                IImageSave iImageSave = (IImageSave)controlSupplier.get();
                if (iImageSave == null) {
                    return;
                }
                FileDialog dialog = TmfFileDialogFactory.create(new Shell(), 8192);
                String[] filters = new String[]{"*.png", "*.gif", "*.jpg", "*.bmp"};
                int[] nArray = new int[4];
                nArray[0] = 5;
                nArray[1] = 2;
                nArray[2] = 4;
                int[] filterTypes = nArray;
                dialog.setFilterExtensions(filters);
                dialog.setFilterIndex(0);
                dialog.setFileName(String.valueOf(name == null ? "Untitled" : name) + ".png");
                String ret = dialog.open();
                if (ret != null && !ret.isEmpty()) {
                    int index = dialog.getFilterIndex();
                    iImageSave.saveImage(ret, filterTypes[index]);
                }
            }
        };
        saveAction.setToolTipText(Messages.AbstractTimeGraphView_ExportImageToolTipText);
        return saveAction;
    }
}

