/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesStatusDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.UnfollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends AbstractTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.resources";
    public static final @NonNull String RESOURCES_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.resources.FOLLOW_CPU";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ResourcesFilterLabelProvider());
        this.setEntryComparator(new ResourcesEntryComparator());
        this.setAutoExpandLevel(1);
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        ResourcesEntry resourcesEntry;
        IStructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (sSel = (IStructuredSelection)selection).getFirstElement() instanceof ResourcesEntry && (resourcesEntry = (ResourcesEntry)sSel.getFirstElement()).getType().equals((Object)ResourcesEntryModel.Type.CPU)) {
            int cpu;
            TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
            Integer data = (Integer)ctx.getData(RESOURCES_FOLLOW_CPU);
            int n = cpu = data != null ? data : -1;
            if (cpu >= 0) {
                menuManager.add((IAction)new UnfollowCpuAction((TmfView)this, resourcesEntry.getId(), resourcesEntry.getTrace()));
            } else {
                menuManager.add((IAction)new FollowCpuAction((TmfView)this, resourcesEntry.getId(), resourcesEntry.getTrace()));
            }
        }
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        ResourcesStatusDataProvider dataProvider = (ResourcesStatusDataProvider)DataProviderManager.getInstance().getDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider", ResourcesStatusDataProvider.class);
        if (dataProvider == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        boolean complete = false;
        ResourcesEntry traceEntry = null;
        HashMap<ResourcesEntryModel, TimeGraphEntry> modelToEntryMap = new HashMap<ResourcesEntryModel, TimeGraphEntry>();
        HashMap<Long, TimeGraphEntry> parentLookupMap = new HashMap<Long, TimeGraphEntry>();
        while (!complete && !subMonitor.isCanceled()) {
            TmfModelResponse response = dataProvider.fetchTree(new TimeQueryFilter(0L, Long.MAX_VALUE, 2), (IProgressMonitor)subMonitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.getDefault().logError("Resources Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            List model = (List)response.getModel();
            if (model != null) {
                for (ResourcesEntryModel entry : model) {
                    if (entry.getType() != ResourcesEntryModel.Type.TRACE) {
                        TimeGraphEntry uiEntry = (TimeGraphEntry)modelToEntryMap.get(entry);
                        if (uiEntry == null) {
                            uiEntry = new ResourcesEntry(entry, trace);
                            modelToEntryMap.put(entry, uiEntry);
                            parentLookupMap.put(entry.getId(), uiEntry);
                            TimeGraphEntry parent = parentLookupMap.getOrDefault(entry.getParentId(), traceEntry);
                            parent.addChild(uiEntry);
                            continue;
                        }
                        uiEntry.updateModel((TimeGraphEntryModel)entry);
                        continue;
                    }
                    this.setStartTime(Long.min(this.getStartTime(), entry.getStartTime()));
                    this.setEndTime(Long.max(this.getEndTime(), entry.getEndTime() + 1L));
                    if (traceEntry != null) {
                        traceEntry.updateModel((TimeGraphEntryModel)entry);
                        continue;
                    }
                    traceEntry = new ResourcesEntry(entry, trace);
                    this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
                }
                Objects.requireNonNull(traceEntry);
                long start = traceEntry.getStartTime();
                long end = traceEntry.getEndTime();
                long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                this.zoomEntries(modelToEntryMap.values(), start, end, resolution, (IProgressMonitor)subMonitor);
            }
            if (subMonitor.isCanceled()) {
                return;
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            subMonitor.worked(1);
            if (complete || subMonitor.isCanceled()) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait for data provider", e);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        if (resolution < 0L) {
            return;
        }
        long start = Long.min(zoomStartTime, zoomEndTime);
        long end = Long.max(zoomStartTime, zoomEndTime);
        @NonNull List times = StateSystemUtils.getTimes((long)start, (long)end, (long)resolution);
        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(start, end, resolution);
        Map<ResourcesStatusDataProvider, Multimap<Long, ResourcesEntry>> resourceEntries = ResourcesView.filterGroupEntries(entries, zoomStartTime, zoomEndTime);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"ResourcesView#zoomEntries", (int)resourceEntries.size());
        for (Map.Entry<ResourcesStatusDataProvider, Multimap<Long, ResourcesEntry>> entry : resourceEntries.entrySet()) {
            Multimap<Long, ResourcesEntry> map;
            SelectionTimeQueryFilter filter;
            ResourcesStatusDataProvider dataProvider = entry.getKey();
            TmfModelResponse response = dataProvider.fetchRowModel(filter = new SelectionTimeQueryFilter(times, (Collection)(map = entry.getValue()).keySet()), monitor);
            List model = (List)response.getModel();
            if (model != null) {
                this.zoomEntries(map, model, response.getStatus() == ITmfResponse.Status.COMPLETED, sampling);
            }
            subMonitor.worked(1);
        }
    }

    private void zoomEntries(Multimap<Long, ResourcesEntry> map, List<ITimeGraphRowModel> model, boolean completed, TimeGraphEntry.Sampling sampling) {
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        for (ITimeGraphRowModel rowModel : model) {
            Collection resourceEntries = map.get((Object)rowModel.getEntryID());
            for (ResourcesEntry resourceEntry : resourceEntries) {
                List<ITimeEvent> events = ResourcesView.createTimeEvents(resourceEntry, rowModel.getStates());
                if (isZoomThread) {
                    this.applyResults(() -> {
                        resourceEntry.setZoomedEventList(events);
                        if (completed) {
                            resourceEntry.setSampling(sampling);
                        }
                    });
                    continue;
                }
                resourceEntry.setEventList(events);
            }
        }
    }

    private static Map<ResourcesStatusDataProvider, Multimap<Long, ResourcesEntry>> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        DataProviderManager manager = DataProviderManager.getInstance();
        Iterable resourceEntries = Iterables.filter(visible, ResourcesEntry.class);
        HashMap<ResourcesStatusDataProvider, Multimap<Long, ResourcesEntry>> quarksToEntries = new HashMap<ResourcesStatusDataProvider, Multimap<Long, ResourcesEntry>>();
        for (ResourcesEntry entry : resourceEntries) {
            ResourcesStatusDataProvider provider;
            if (zoomStartTime > entry.getEndTime() || zoomEndTime < entry.getStartTime() || (provider = (ResourcesStatusDataProvider)manager.getDataProvider(entry.getTrace(), "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ResourcesStatusDataProvider", ResourcesStatusDataProvider.class)) == null) continue;
            Multimap multimap = quarksToEntries.computeIfAbsent(provider, p -> HashMultimap.create());
            multimap.put((Object)entry.getModel().getId(), (Object)entry);
        }
        return quarksToEntries;
    }

    private static List<ITimeEvent> createTimeEvents(ResourcesEntry resourceEntry, List<ITimeGraphState> value) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(value.size());
        TimeEvent prev = null;
        for (ITimeGraphState interval : value) {
            long prevEnd;
            TimeEvent event = ResourcesView.createTimeEvent(interval, resourceEntry);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                events.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)resourceEntry, prevEnd, event.getTime() - prevEnd, -1));
            }
            prev = event;
            events.add((ITimeEvent)event);
        }
        return events;
    }

    private static TimeEvent createTimeEvent(ITimeGraphState state, ResourcesEntry resourceEntry) {
        if (state.getValue() == Integer.MIN_VALUE) {
            return new NullTimeEvent((ITimeGraphEntry)resourceEntry, state.getStartTime(), state.getDuration());
        }
        String label = state.getLabel();
        if (label != null) {
            return new NamedTimeEvent((ITimeGraphEntry)resourceEntry, state.getStartTime(), state.getDuration(), (int)state.getValue(), label);
        }
        return new TimeEvent((ITimeGraphEntry)resourceEntry, state.getStartTime(), state.getDuration(), (int)state.getValue());
    }

    @TmfSignalHandler
    public void listenToCpu(TmfCpuSelectedSignal signal) {
        int data = signal.getCore() >= 0 ? signal.getCore() : -1;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(RESOURCES_FOLLOW_CPU, (Object)data));
    }

    private static class ResourcesEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ResourcesEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            ResourcesEntry entry1 = (ResourcesEntry)o1;
            ResourcesEntry entry2 = (ResourcesEntry)o2;
            if (entry1.getType() == ResourcesEntryModel.Type.TRACE && entry2.getType() == ResourcesEntryModel.Type.TRACE) {
                return entry1.getName().compareTo(entry2.getName());
            }
            return entry1.compareTo((ITimeGraphEntry)entry2);
        }
    }

    private static class ResourcesFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ResourcesFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ResourcesEntry entry = (ResourcesEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }
}

