/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.undo;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextCommand;

public class StructuredTextCommandImpl
extends AbstractCommand
implements StructuredTextCommand {
    protected IDocument fDocument = null;
    protected String fTextDeleted = null;
    protected int fTextEnd = -1;
    protected String fTextInserted = null;
    protected int fTextStart = -1;

    protected StructuredTextCommandImpl() {
    }

    public StructuredTextCommandImpl(IDocument document) {
        this();
        this.fDocument = document;
    }

    public void execute() {
    }

    public String getTextDeleted() {
        return this.fTextDeleted;
    }

    public int getTextEnd() {
        return this.fTextEnd;
    }

    public String getTextInserted() {
        return this.fTextInserted;
    }

    public int getTextStart() {
        return this.fTextStart;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        if (this.fDocument instanceof IStructuredDocument) {
            ((IStructuredDocument)this.fDocument).replaceText(this, this.fTextStart, this.fTextDeleted.length(), this.fTextInserted, true);
        } else {
            try {
                this.fDocument.replace(this.fTextStart, this.fTextDeleted.length(), this.fTextInserted);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }

    public void setTextDeleted(String textDeleted) {
        this.fTextDeleted = textDeleted;
    }

    public void setTextEnd(int textEnd) {
        this.fTextEnd = textEnd;
    }

    public void setTextInserted(String textInserted) {
        this.fTextInserted = textInserted;
    }

    public void setTextStart(int textStart) {
        this.fTextStart = textStart;
    }

    public void undo() {
        if (this.fDocument instanceof IStructuredDocument) {
            ((IStructuredDocument)this.fDocument).replaceText(this, this.fTextStart, this.fTextInserted.length(), this.fTextDeleted, true);
        } else {
            try {
                this.fDocument.replace(this.fTextStart, this.fTextInserted.length(), this.fTextDeleted);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }
}

