/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.inputoutput;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Disk {
    private static final int MINORBITS = 20;
    private static final int MINORMASK = 1048575;
    private final int fDev;
    private final int fDiskQuark;
    private final ITmfStateSystem fSs;
    private @Nullable String fDiskName = null;

    public Disk(Integer dev, ITmfStateSystem ss, int diskQuark) {
        this.fDev = dev;
        this.fSs = ss;
        this.fDiskQuark = diskQuark;
        ITmfStateInterval diskNameInterval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)diskQuark, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        if (diskNameInterval != null) {
            this.fDiskName = diskNameInterval.getStateValue().unboxStr();
        }
    }

    public int getDeviceId() {
        return this.fDev;
    }

    public String getDiskName() {
        String diskName = this.fDiskName;
        if (diskName == null) {
            return this.getDeviceIdString();
        }
        return diskName;
    }

    public int getQuark() {
        return this.fDiskQuark;
    }

    public void setDiskName(String diskname) {
        this.fDiskName = diskname;
    }

    public String getDeviceIdString() {
        return Disk.extractDeviceIdString(this.fDev);
    }

    protected static String extractDeviceIdString(int dev) {
        int major = dev >> 20;
        int minor = dev & 0xFFFFF;
        return String.valueOf(major) + "," + minor;
    }

    public double getSectorsAt(long ts, IoOperationType type) {
        int rwSectorQuark;
        ITmfStateSystem ss = this.fSs;
        if (type == IoOperationType.READ) {
            rwSectorQuark = ss.optQuarkRelative(this.fDiskQuark, new String[]{"sectors_read"});
        } else if (type == IoOperationType.WRITE) {
            rwSectorQuark = ss.optQuarkRelative(this.fDiskQuark, new String[]{"sectors_written"});
        } else {
            return 0.0;
        }
        long time = Math.max(ts, ss.getStartTime());
        time = Math.min(time, ss.getCurrentEndTime());
        try {
            List states = ss.queryFullState(time);
            return Disk.extractCount(rwSectorQuark, ss, states, time);
        }
        catch (StateSystemDisposedException e) {
            Activator.getDefault().logError("Error getting disk IO Activity", e);
            return 0.0;
        }
    }

    protected static double extractCount(int sectorQuark, ITmfStateSystem ss, List<ITmfStateInterval> states, long ts) {
        String sectorName = ss.getAttributeName(sectorQuark);
        int rw = sectorName.equals("sectors_read") ? 2 : 1;
        Object stateValue = states.get(sectorQuark).getValue();
        double count = stateValue instanceof Number ? ((Number)stateValue).doubleValue() : 0.0;
        int diskQuark = ss.getParentAttributeQuark(sectorQuark);
        int driverQ = ss.optQuarkRelative(diskQuark, new String[]{"Driver_queue"});
        if (driverQ == -2) {
            return count;
        }
        for (Integer driverSlotQuark : ss.getSubAttributes(driverQ, false)) {
            ITmfStateInterval interval;
            Object size;
            int sizeQuark = ss.optQuarkRelative(driverSlotQuark.intValue(), new String[]{"Request_size"});
            if (sizeQuark == -2 || !((size = (interval = states.get(sizeQuark)).getValue()) instanceof Number) || !Objects.equals(rw, states.get(driverSlotQuark).getValue())) continue;
            count += Disk.interpolate(ts, interval, (Number)size);
        }
        return count;
    }

    private static double interpolate(long ts, ITmfStateInterval interval, Number size) {
        long runningTime = interval.getEndTime() - interval.getStartTime() + 1L;
        return (double)(ts - interval.getStartTime()) * size.doubleValue() / (double)runningTime;
    }

    public boolean hasActivity() {
        return this.queueIsActive("Waiting_queue") && this.queueIsActive("Driver_queue");
    }

    private boolean queueIsActive(String queue) {
        int quark = this.fSs.optQuarkRelative(this.fDiskQuark, new String[]{queue});
        return quark != -2 && !this.fSs.getSubAttributes(quark, false).isEmpty();
    }

    public String toString() {
        return "Disk: [" + this.getDeviceIdString() + ',' + this.fDiskName + ']';
    }

    public int hashCode() {
        return Objects.hash(this.fSs, this.fDev);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof Disk) {
            Disk disk = (Disk)o;
            return this.fSs.equals(disk.fSs) && this.fDev == disk.fDev;
        }
        return false;
    }
}

