/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.actions;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.preferences.MakePreferencePage;
import org.eclipse.cdt.make.ui.TargetBuild;
import org.eclipse.cdt.make.ui.actions.AbstractTargetAction;
import org.eclipse.cdt.make.ui.dialogs.BuildTargetDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;

public class BuildLastTargetAction
extends AbstractTargetAction {
    public void run(IAction action) {
        IContainer container = this.getSelectedContainer();
        if (container != null) {
            String name = null;
            if (MakePreferencePage.useProjectLastMakeTarget()) {
                try {
                    name = (String)container.getProject().getSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTargetContainer"));
                    if (name != null) {
                        Object lastTargetContainer = name.length() == 0 ? container.getProject() : container.getProject().getFolder((IPath)new Path(name));
                        if (lastTargetContainer.exists()) {
                            container = lastTargetContainer;
                        }
                        name = (String)container.getSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"));
                    }
                }
                catch (CoreException lastTargetContainer) {}
            } else {
                if (MakePreferencePage.useProjectRootForLastMakeTarget()) {
                    container = container.getProject();
                }
                try {
                    name = (String)container.getSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"));
                }
                catch (CoreException lastTargetContainer) {
                    // empty catch block
                }
            }
            try {
                IMakeTarget target;
                boolean showDialog = true;
                if (name != null && (target = MakeCorePlugin.getDefault().getTargetManager().findTarget(container, name)) != null) {
                    TargetBuild.buildTargets(this.getShell(), new IMakeTarget[]{target});
                    showDialog = false;
                    IPath path = container.getProjectRelativePath();
                    container.getProject().setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTargetContainer"), (Object)path.toString());
                }
                if (showDialog) {
                    IMakeTarget target2;
                    boolean recursive = MakePreferencePage.useProjectLastMakeTarget();
                    BuildTargetDialog dialog = new BuildTargetDialog(this.getShell(), container, recursive);
                    if (dialog.open() == 0 && (target2 = dialog.getTarget()) != null) {
                        container.setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"), (Object)target2.getName());
                        IPath path = target2.getContainer().getProjectRelativePath();
                        container.getProject().setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTargetContainer"), (Object)path.toString());
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }
}

