/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.Location;

public class EditorSearchContext
implements ISearchContext {
    private final String searchText;
    private final Location location;
    private final String filename;
    private final Set<ProjectCoordinate> availableDependencies;

    public EditorSearchContext(String searchText, Location location, String filename, Set<ProjectCoordinate> availableDependencies) {
        this.searchText = Objects.requireNonNull(searchText);
        this.location = Objects.requireNonNull(location);
        this.filename = filename;
        this.availableDependencies = availableDependencies;
    }

    @Override
    public String getSearchText() {
        return this.searchText;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean isRestrictedByFilename() {
        return this.filename != null;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public boolean isRestrictedByDependencies() {
        return this.availableDependencies != null && !this.availableDependencies.isEmpty();
    }

    @Override
    public Set<ProjectCoordinate> getDependencies() {
        return this.availableDependencies;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

