/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderUtils {
    private static final Unsafe UNSAFE;
    private static final JavaMethod<ClassLoader, Package[]> GET_PACKAGES_METHOD;
    private static final JavaMethod<ClassLoader, Package> GET_PACKAGE_METHOD;

    private static <T> JavaMethod<ClassLoader, T> getMethodWithFallback(Class<T> clazz, Class<?>[] params, String firstChoice, String fallback) {
        JavaMethod<Class<ClassLoader>, T> method;
        try {
            method = JavaReflectionUtil.method(ClassLoader.class, clazz, firstChoice, params);
        }
        catch (Throwable e) {
            method = JavaReflectionUtil.method(ClassLoader.class, clazz, fallback, params);
        }
        return method;
    }

    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getSystemClassLoader().getParent();
    }

    public static void tryClose(@Nullable ClassLoader classLoader) {
        CompositeStoppable.stoppable(classLoader).stop();
    }

    public static void disableUrlConnectionCaching() {
        try {
            URL url = new URL("jar:file://valid_jar_url_syntax.jar!/");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static JavaMethod<ClassLoader, Package[]> getPackagesMethod() {
        return GET_PACKAGES_METHOD;
    }

    public static JavaMethod<ClassLoader, Package> getPackageMethod() {
        return GET_PACKAGE_METHOD;
    }

    public static <T> Class<T> define(ClassLoader targetClassLoader, String className, byte[] clazzBytes) {
        return (Class)Cast.uncheckedCast(UNSAFE.defineClass(className, clazzBytes, 0, clazzBytes.length, targetClassLoader, null));
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        GET_PACKAGES_METHOD = ClassLoaderUtils.getMethodWithFallback(Package[].class, new Class[0], "getDefinedPackages", "getPackages");
        GET_PACKAGE_METHOD = ClassLoaderUtils.getMethodWithFallback(Package.class, new Class[]{String.class}, "getDefinedPackage", "getPackage");
    }
}

