/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsRewriteOperations;
import org.eclipse.jdt.internal.corext.fix.TypeAnnotationRewriteOperations;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.TypeAnnotationSubProcessor;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class NullAnnotationsFix
extends CompilationUnitRewriteOperationsFix {
    private CompilationUnit cu;

    public NullAnnotationsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
        this.cu = compilationUnit;
    }

    public CompilationUnit getCu() {
        return this.cu;
    }

    public static boolean isComplainingAboutArgument(ASTNode selectedNode) {
        if (!(selectedNode instanceof SimpleName)) {
            return false;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        IBinding binding = nameNode.resolveBinding();
        if (binding.getKind() == 3 && ((IVariableBinding)binding).isParameter()) {
            return true;
        }
        VariableDeclaration argDecl = (VariableDeclaration)ASTNodes.getParent((ASTNode)selectedNode, VariableDeclaration.class);
        if (argDecl != null) {
            binding = argDecl.resolveBinding();
        }
        return binding.getKind() == 3 && ((IVariableBinding)binding).isParameter();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isComplainingAboutReturn(ASTNode selectedNode) {
        if (selectedNode.getParent().getNodeType() != 41) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            if (selectedNode == null) {
                return false;
            }
            selectedNode = selectedNode.getParent();
lbl6:
            // 2 sources

            ** while (!(selectedNode instanceof Type))
        }
lbl7:
        // 1 sources

        return selectedNode.getLocationInParent() == MethodDeclaration.RETURN_TYPE2_PROPERTY;
    }

    public static NullAnnotationsFix createNullAnnotationInSignatureFix(CompilationUnit compilationUnit, IProblemLocation problem, NullAnnotationsRewriteOperations.ChangeKind changeKind, boolean isArgumentProblem) {
        IJavaElement javaElement = compilationUnit.getJavaElement();
        String nullableAnnotationName = NullAnnotationsFix.getNullableAnnotationName(javaElement, false);
        String nonNullAnnotationName = NullAnnotationsFix.getNonNullAnnotationName(javaElement, false);
        NullAnnotationsRewriteOperations.Builder builder = new NullAnnotationsRewriteOperations.Builder(problem, compilationUnit, nullableAnnotationName, nonNullAnnotationName, true, isArgumentProblem, changeKind);
        boolean addNonNull = false;
        switch (problem.getProblemId()) {
            case 67109779: 
            case 67109780: {
                if (changeKind != NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN) break;
                addNonNull = true;
                builder.swapAnnotations();
                break;
            }
            case 67109778: 
            case 67109781: {
                if (changeKind == NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN) break;
                addNonNull = true;
                builder.swapAnnotations();
                break;
            }
            case 16778126: 
            case 16778127: 
            case 16778128: 
            case 536871845: {
                if (isArgumentProblem != (changeKind != NullAnnotationsRewriteOperations.ChangeKind.TARGET)) break;
                addNonNull = true;
                builder.swapAnnotations();
                break;
            }
            case 67109803: {
                if (isArgumentProblem && changeKind == NullAnnotationsRewriteOperations.ChangeKind.INVERSE) {
                    return null;
                }
            }
            case 67109804: {
                if (changeKind != NullAnnotationsRewriteOperations.ChangeKind.INVERSE && changeKind != NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN) break;
                addNonNull = true;
                builder.swapAnnotations();
            }
        }
        NullAnnotationsRewriteOperations.SignatureAnnotationRewriteOperation operation = builder.createAddAnnotationOperation(null, false, changeKind);
        if (operation == null) {
            return null;
        }
        if (addNonNull) {
            operation.fRemoveIfNonNullByDefault = true;
            operation.fNonNullByDefaultName = NullAnnotationsFix.getNonNullByDefaultAnnotationName(javaElement, false);
        }
        return new NullAnnotationsFix(operation.getMessage(), operation.getCompilationUnit(), new NullAnnotationsRewriteOperations.SignatureAnnotationRewriteOperation[]{operation});
    }

    public static NullAnnotationsFix createRemoveRedundantNullAnnotationsFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation operation = new NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation(compilationUnit, problem);
        return new NullAnnotationsFix(FixMessages.NullAnnotationsRewriteOperations_remove_redundant_nullness_annotation, compilationUnit, new NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation[]{operation});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] locations, int problemID) {
        String message;
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        if (locations == null) {
            IProblem[] problems = compilationUnit.getProblems();
            locations = new IProblemLocation[problems.length];
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getID() == problemID) {
                    locations[i] = new ProblemLocation(problems[i]);
                }
                ++i;
            }
        }
        if (TypeAnnotationSubProcessor.hasFixFor(problemID)) {
            boolean isMove = NullAnnotationsFix.createMoveTypeAnnotationOperations(compilationUnit, locations, operations);
            message = isMove ? FixMessages.TypeAnnotationFix_move : FixMessages.TypeAnnotationFix_remove;
        } else {
            NullAnnotationsFix.createAddNullAnnotationOperations(compilationUnit, locations, operations);
            NullAnnotationsFix.createRemoveRedundantNullAnnotationsOperations(compilationUnit, locations, operations);
            message = FixMessages.NullAnnotationsFix_add_annotation_change_name;
        }
        if (operations.size() == 0) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new NullAnnotationsFix(message, compilationUnit, operationsArray);
    }

    private static boolean createMoveTypeAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations) {
        boolean isMove = false;
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation location = iProblemLocationArray[n2];
            if (location != null) {
                TypeAnnotationRewriteOperations.MoveTypeAnnotationRewriteOperation operation = new TypeAnnotationRewriteOperations.MoveTypeAnnotationRewriteOperation(compilationUnit, location);
                operations.add(operation);
                isMove |= operation.isMove();
            }
            ++n2;
        }
        return isMove;
    }

    private static void createAddNullAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
        String nullableAnnotationName = NullAnnotationsFix.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = NullAnnotationsFix.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        HashSet<String> handledPositions = new HashSet<String>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            if (problem != null) {
                boolean isArgumentProblem = NullAnnotationsFix.isComplainingAboutArgument(problem.getCoveredNode(compilationUnit));
                NullAnnotationsRewriteOperations.Builder builder = new NullAnnotationsRewriteOperations.Builder(problem, compilationUnit, nullableAnnotationName, nonNullAnnotationName, false, isArgumentProblem, NullAnnotationsRewriteOperations.ChangeKind.LOCAL);
                boolean addNonNull = false;
                switch (problem.getProblemId()) {
                    case 67109779: 
                    case 67109780: {
                        break;
                    }
                    case 67109778: 
                    case 67109781: {
                        addNonNull = true;
                        builder.swapAnnotations();
                        break;
                    }
                    case 16778126: 
                    case 16778127: 
                    case 16778128: 
                    case 536871845: {
                        if (!isArgumentProblem) break;
                        addNonNull = true;
                        builder.swapAnnotations();
                    }
                }
                NullAnnotationsRewriteOperations.SignatureAnnotationRewriteOperation fix = builder.createAddAnnotationOperation(handledPositions, true, NullAnnotationsRewriteOperations.ChangeKind.LOCAL);
                if (fix != null) {
                    if (addNonNull) {
                        fix.fRemoveIfNonNullByDefault = true;
                        fix.fNonNullByDefaultName = NullAnnotationsFix.getNonNullByDefaultAnnotationName(compilationUnit.getJavaElement(), false);
                    }
                    result.add(fix);
                }
            }
            ++i;
        }
    }

    private static void createRemoveRedundantNullAnnotationsOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
        int i = 0;
        while (i < locations.length) {
            int problemId;
            IProblemLocation problem = locations[i];
            if (problem != null && ((problemId = problem.getProblemId()) == 67109786 || problemId == 536871838 || problemId == 536871839 || problemId == 536871840 || problemId == 536871974 || problemId == 536871975)) {
                NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation operation = new NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation(compilationUnit, problem);
                result.add(operation);
            }
            ++i;
        }
    }

    public static boolean hasExplicitNullAnnotation(ICompilationUnit compilationUnit, int offset) {
        return false;
    }

    public static String getNullableAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        return NullAnnotationsFix.getAnnotationName(javaElement, makeSimple, "org.eclipse.jdt.core.compiler.annotation.nullable");
    }

    public static String getNonNullAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        return NullAnnotationsFix.getAnnotationName(javaElement, makeSimple, "org.eclipse.jdt.core.compiler.annotation.nonnull");
    }

    public static String getNonNullByDefaultAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        return NullAnnotationsFix.getAnnotationName(javaElement, makeSimple, "org.eclipse.jdt.core.compiler.annotation.nonnullbydefault");
    }

    private static String getAnnotationName(IJavaElement javaElement, boolean makeSimple, String annotation) {
        int lastDot;
        String qualifiedName = javaElement.getJavaProject().getOption(annotation, true);
        if (makeSimple && qualifiedName != null && (lastDot = qualifiedName.lastIndexOf(46)) != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }
}

