/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsReftable;
import org.eclipse.jgit.internal.storage.reftable.Reftable;

public class ReftableStack
implements AutoCloseable {
    private final List<Reftable> tables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReftableStack open(DfsReader ctx, List<DfsReftable> tables) throws IOException {
        ReftableStack stack = new ReftableStack(tables.size());
        boolean close = true;
        try {
            for (DfsReftable t : tables) {
                stack.tables.add(t.open(ctx));
            }
            close = false;
            ReftableStack reftableStack = stack;
            return reftableStack;
        }
        finally {
            if (close) {
                stack.close();
            }
        }
    }

    private ReftableStack(int tableCnt) {
        this.tables = new ArrayList<Reftable>(tableCnt);
    }

    public List<Reftable> readers() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public void close() {
        for (Reftable t : this.tables) {
            try {
                t.close();
            }
            catch (IOException iOException) {}
        }
    }
}

